/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lejos.pc.comm.NXTCommLogListener;
import lejos.pc.comm.NXTConnector;
import lejos.pc.tools.ConsoleViewerUI;
import lejos.pc.tools.ToolsLogger;

public class ConsoleViewComms {
    private InputStream is = null;
    private OutputStream os = null;
    private NXTConnector con;
    private ConsoleViewerUI viewer;
    private Reader reader;
    private boolean connected = false;
    private boolean daemon;
    private boolean lcd;

    public ConsoleViewComms(ConsoleViewerUI viewer, boolean daemon, boolean lcd) {
        this.daemon = daemon;
        this.viewer = viewer;
        this.lcd = lcd;
        this.reader = new Reader();
        this.reader.setDaemon(daemon);
        this.reader.start();
    }

    public boolean connectTo(String name, String address, boolean useUSB) {
        return this.connectTo(name, address, useUSB ? 1 : 2);
    }

    public boolean connectTo(String name, String address, int protocol) {
        this.con = new NXTConnector();
        this.con.addLogListener((NXTCommLogListener)new ToolsLogger());
        if (!this.con.connectTo(name, address, protocol)) {
            return false;
        }
        this.is = this.con.getInputStream();
        this.os = this.con.getOutputStream();
        if (this.is == null || this.os == null) {
            return false;
        }
        try {
            byte[] hello = new byte[]{67, 79, (byte)(this.lcd ? 79 : 78)};
            this.os.write(hello);
            this.os.flush();
        }
        catch (IOException e) {
            this.viewer.logMessage("Handshake failed to write: " + e.getMessage());
            this.connected = false;
            return false;
        }
        name = this.con.getNXTInfo().name;
        address = this.con.getNXTInfo().deviceAddress;
        this.viewer.connectedTo(name, address);
        this.viewer.logMessage("Connected to " + name + " " + address);
        this.connected = true;
        return this.connected;
    }

    public void close() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connected = false;
    }

    private class Reader
    extends Thread {
        byte[] lcdBuffer = new byte[800];

        private Reader() {
        }

        private int readBuffer() throws IOException {
            int cnt;
            int len;
            for (cnt = 0; cnt < this.lcdBuffer.length; cnt += len) {
                len = ConsoleViewComms.this.is.read(this.lcdBuffer, cnt, this.lcdBuffer.length - cnt);
                if (len >= 0) continue;
                return -1;
            }
            return cnt;
        }

        public void run() {
            while (true) {
                block7: {
                    if (ConsoleViewComms.this.connected) {
                        try {
                            int input;
                            while ((input = ConsoleViewComms.this.is.read()) >= 0) {
                                if (input == 255) {
                                    if (this.readBuffer() < 0) break;
                                    ConsoleViewComms.this.viewer.updateLCD(this.lcdBuffer);
                                    continue;
                                }
                                ConsoleViewComms.this.viewer.append("" + (char)input);
                            }
                            ConsoleViewComms.this.close();
                            if (!ConsoleViewComms.this.daemon) {
                                return;
                            }
                        }
                        catch (IOException e) {
                            ConsoleViewComms.this.close();
                            if (ConsoleViewComms.this.daemon) break block7;
                            return;
                        }
                    }
                }
                Thread.yield();
            }
        }
    }
}

