/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.proposal;

import lejos.geom.Point;
import lejos.robotics.MoveListener;
import lejos.robotics.Movement;
import lejos.robotics.MovementProvider;
import lejos.robotics.Pose;
import lejos.robotics.localization.PoseProvider;

public class DeadReckonerPoseProvider
implements MoveListener,
PoseProvider {
    private float x = 0.0f;
    private float y = 0.0f;
    private float heading = 0.0f;
    private float angle0;
    private float distance0;
    MovementProvider mp;
    boolean current = true;

    public DeadReckonerPoseProvider(MovementProvider mp) {
        mp.addMoveListener(this);
    }

    public Pose getPose() {
        if (!this.current) {
            this.updatePose(this.mp.getMovement());
        }
        return new Pose(this.x, this.y, this.heading);
    }

    public void movementStarted(Movement event, MovementProvider mp) {
        this.angle0 = 0.0f;
        this.distance0 = 0.0f;
        this.current = false;
        this.mp = mp;
    }

    public void movementStopped(Movement event, MovementProvider mp) {
        this.updatePose(event);
    }

    private void updatePose(Movement event) {
        float angle = event.getAngleTurned() - this.angle0;
        float distance = event.getDistanceTraveled() - this.distance0;
        double dx = 0.0;
        double dy = 0.0;
        double headingRad = Math.toRadians(this.heading);
        if ((double)Math.abs(angle) > 0.5) {
            double turnRad = Math.toRadians(angle);
            double radius = event.getArcRadius();
            if (radius != 0.0) {
                dy = radius * (Math.cos(headingRad) - Math.cos(headingRad + turnRad));
                dx = radius * (Math.sin(headingRad + turnRad) - Math.sin(headingRad));
            }
        } else if ((double)Math.abs(distance) > 0.01) {
            dx = distance * (float)Math.cos(headingRad);
            dy = distance * (float)Math.sin(headingRad);
        }
        this.heading = this.normalize(this.heading + angle);
        this.x = (float)((double)this.x + dx);
        this.y = (float)((double)this.y + dy);
        this.angle0 = event.getAngleTurned();
        this.distance0 = event.getDistanceTraveled();
        this.current = !event.isMoving();
    }

    private float normalize(float angle) {
        float a;
        for (a = angle; a > 180.0f; a -= 360.0f) {
        }
        while (a < -180.0f) {
            a += 360.0f;
        }
        return a;
    }

    public void setPosition(Point p) {
        this.x = p.x;
        this.y = p.y;
        this.current = true;
    }

    void setHeading(float heading) {
        this.heading = heading;
        this.current = true;
    }
}

