/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.navigation;

import lejos.robotics.DirectionFinder;
import lejos.robotics.TachoMotor;
import lejos.robotics.navigation.TachoPilot;

public class CompassPilot
extends TachoPilot {
    protected DirectionFinder compass;
    private Regulator regulator = new Regulator();
    private int _heading;
    private boolean _traveling = false;
    private boolean _rotating = false;
    private boolean _regulating = false;
    private float _distance;
    private byte _direction;
    public int _angle0;

    public boolean isRotating() {
        return this._rotating;
    }

    public boolean isTraveling() {
        return this._traveling;
    }

    public CompassPilot(DirectionFinder compass, float wheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor) {
        this(compass, wheelDiameter, trackWidth, leftMotor, rightMotor, false);
    }

    public CompassPilot(DirectionFinder compass, float wheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor, boolean reverse) {
        super(wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
        this.compass = compass;
        this._heading = this.getCompassHeading();
        this.regulator.setDaemon(true);
        this.regulator.start();
    }

    public DirectionFinder getCompass() {
        return this.compass;
    }

    public float getAngle() {
        return this.compass.getDegreesCartesian() - (float)this._angle0;
    }

    public int getHeading() {
        return this._heading;
    }

    public int getCompassHeading() {
        int heading = Math.round(this.compass.getDegreesCartesian());
        if (heading > 360) {
            heading -= 360;
        }
        if (heading < 0) {
            heading += 0;
        }
        return heading;
    }

    public void setHeading(int angle) {
        this._heading = angle;
    }

    public synchronized void calibrate() {
        int spd = this._motorSpeed;
        this.setSpeed(100);
        this.compass.startCalibration();
        super.rotate(360.0f, false);
        this.compass.stopCalibration();
        this.setSpeed(spd);
    }

    public void resetCartesianZero() {
        this.compass.resetCartesianZero();
        this._heading = 0;
        this._angle0 = 0;
    }

    private int getHeadingError() {
        int err;
        for (err = this.getCompassHeading() - this._heading; err < -180; err += 360) {
        }
        while (err > 180) {
            err -= 360;
        }
        return err;
    }

    public void travel(float distance, boolean immediateReturn) {
        this.reset();
        this._distance = distance;
        if (this._distance > 0.0f) {
            this._direction = 1;
            this.forward();
        } else {
            this._direction = (byte)-1;
            this.backward();
        }
        this._traveling = true;
        this._rotating = false;
        this._regulating = true;
        if (immediateReturn) {
            return;
        }
        while (this._traveling) {
            Thread.yield();
        }
    }

    public void travel(float distance) {
        this.travel(distance, false);
    }

    public void rotateTo(float angle, boolean immediateReturn) {
        this.rotate(angle - (float)this._heading, immediateReturn);
    }

    public void rotateTo(float angle) {
        this.rotateTo(angle, false);
    }

    public void rotate(float angle, boolean immediateReturn) {
        this.reset();
        this.performRotation(angle);
        this._traveling = false;
        this._rotating = true;
        this._regulating = true;
        this._heading = (int)((float)this._heading + angle);
        if (immediateReturn) {
            return;
        }
        while (this._rotating) {
            Thread.yield();
        }
        this.stop();
    }

    public void rotate(float angle) {
        this.rotate(angle, false);
    }

    public void reset() {
        super.reset();
        this._angle0 = this.getCompassHeading();
    }

    public boolean isMoving() {
        return super.isMoving() || this._rotating || this._traveling;
    }

    private void stopNow() {
        this.stop();
    }

    public void stop() {
        super.stop();
        this._regulating = false;
        this._traveling = false;
        this._rotating = false;
        while (this.isMoving()) {
            super.stop();
            Thread.yield();
        }
    }

    private boolean pilotIsMoving() {
        return super.isMoving();
    }

    private void performRotation(float angle) {
        if (angle > 180.0f) {
            angle -= 360.0f;
        }
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        if (angle > 5.0f) {
            angle -= 3.0f;
        }
        if (angle < -5.0f) {
            angle += 3.0f;
        }
        super.rotate(angle, false);
    }

    class Regulator
    extends Thread {
        Regulator() {
        }

        public void run() {
            while (true) {
                if (!CompassPilot.this._regulating) {
                    Thread.yield();
                    continue;
                }
                if (CompassPilot.this._traveling) {
                    if ((float)CompassPilot.this._direction * (CompassPilot.this.getTravelDistance() - CompassPilot.this._distance) >= 0.0f) {
                        CompassPilot.this.stopNow();
                    } else {
                        float gain = -3.0f;
                        int error = (int)(gain * (float)CompassPilot.this.getHeadingError());
                        CompassPilot.this.steer(CompassPilot.this._direction * error, 360 * CompassPilot.this._direction, true);
                    }
                }
                if (CompassPilot.this._rotating) {
                    int error = CompassPilot.this.getHeadingError();
                    if (Math.abs(error) > 3) {
                        CompassPilot.this.performRotation(-error);
                    } else {
                        CompassPilot.this.stopNow();
                    }
                }
                Thread.yield();
            }
        }
    }
}

