/*
 * Decompiled with CFR 0.152.
 */
package lejos.realtime;

import lejos.realtime.AsyncEventHandler;
import lejos.realtime.RelativeTime;
import lejos.realtime.SchedulingParameters;

public class ReleaseParameters
extends SchedulingParameters {
    private RelativeTime cost;
    private RelativeTime deadline;
    private AsyncEventHandler costOverrunHandler;
    private AsyncEventHandler deadlineMissHandler;

    public ReleaseParameters() {
        this(null, null, null, null);
    }

    public ReleaseParameters(RelativeTime cost, RelativeTime deadline, AsyncEventHandler overrunHandler, AsyncEventHandler missHandler) {
        this.setCost(cost);
        this.setDeadline(deadline);
        this.setCostOverrunHandler(overrunHandler);
        this.setDeadlineMissHandler(missHandler);
    }

    public Object clone() {
        return new ReleaseParameters(this.cost, this.deadline, this.costOverrunHandler, this.deadlineMissHandler);
    }

    public RelativeTime getCost() {
        return this.cost;
    }

    public void setCost(RelativeTime cost) {
        if (cost == null) {
            cost = new RelativeTime(0L, 0);
        }
        if (cost.getMilliseconds() < 0L) {
            throw new IllegalArgumentException("Cost must be greater than 0.");
        }
        this.cost = cost;
    }

    public RelativeTime getDeadline() {
        return this.deadline;
    }

    public void setDeadline(RelativeTime deadline) {
        if (deadline == null) {
            deadline = new RelativeTime(0L, 0);
        }
        if (deadline.getMilliseconds() < 0L) {
            throw new IllegalArgumentException("Deadline must be greater than zero.");
        }
        this.deadline = deadline;
    }

    public AsyncEventHandler getDeadlineMissHandler() {
        return this.deadlineMissHandler;
    }

    public void setDeadlineMissHandler(AsyncEventHandler missHandler) {
        this.deadlineMissHandler = missHandler;
    }

    public AsyncEventHandler getCostOverrunHandler() {
        return this.costOverrunHandler;
    }

    public void setCostOverrunHandler(AsyncEventHandler overrunHandler) {
        this.costOverrunHandler = overrunHandler;
    }

    public boolean setIfFeasible(RelativeTime cost, RelativeTime deadline) {
        throw new UnsupportedOperationException("Not overrided yet.");
    }
}

