/*
 * Decompiled with CFR 0.152.
 */
package lejos.realtime;

import java.util.ArrayList;
import lejos.realtime.PriorityScheduler;
import lejos.realtime.RealtimeThread;
import lejos.realtime.Schedulable;

public class RMScheduler
extends PriorityScheduler {
    protected RMScheduler() {
        super("RMScheduler");
    }

    public static PriorityScheduler instance() {
        if (current == null) {
            current = new RMScheduler();
        }
        if (RMScheduler.current.policy != "RMScheduler") {
            current = new RMScheduler();
        }
        return current;
    }

    public boolean isFeasible() {
        ArrayList[] allThreads = new ArrayList[this.getMaxPriority() + 1];
        for (int i = 0; i < allThreads.length; ++i) {
            allThreads[i] = new ArrayList();
        }
        float u = 0.0f;
        int n = this.feasabilityList.size();
        if (n == 0) {
            return true;
        }
        int wt = 0;
        int t = 1;
        for (Schedulable schedulable : this.feasabilityList) {
            if (!(schedulable instanceof RealtimeThread)) continue;
            RealtimeThread rtThread = (RealtimeThread)schedulable;
            int priority = RMScheduler.getThreadPriority(rtThread);
            allThreads[priority].add(rtThread);
            float utmp = (float)RMScheduler.getThreadCost(rtThread) / (float)RMScheduler.getThreadPeriod(rtThread);
            u += utmp;
        }
        if (u > 1.0f) {
            return false;
        }
        if ((double)u < (double)n * (Math.pow(2.0, 1.0 / (double)n) - 1.0)) {
            return true;
        }
        for (Schedulable s : this.feasabilityList) {
            int priority = 0;
            if (!(s instanceof RealtimeThread)) continue;
            RealtimeThread rtThread = (RealtimeThread)s;
            priority = RMScheduler.getThreadPriority(rtThread);
            while (wt != t) {
                t = wt;
                wt = RMScheduler.getWorkTime(allThreads, priority, t);
            }
            int q = (int)Math.ceil((long)wt / RMScheduler.getThreadPeriod(rtThread));
            t = 1;
            wt = 0;
            int[] ct = new int[q];
            for (int m = 1; m <= q; ++m) {
                while (wt != t) {
                    t = wt;
                    wt = RMScheduler.getWorkTimeForResponseTime(allThreads, priority, t, rtThread, m);
                }
                ct[m - 1] = wt - m * (int)RMScheduler.getThreadPeriod(rtThread);
            }
            int r = ct[0];
            for (int i = 1; i < q; ++i) {
                if (ct[i] <= r) continue;
                r = ct[i];
            }
            if ((long)r <= RMScheduler.getThreadDeadline(rtThread)) continue;
            return false;
        }
        return false;
    }
}

