/*
 * Decompiled with CFR 0.152.
 */
package lejos.realtime;

import java.util.ArrayList;
import lejos.realtime.MemoryParameters;
import lejos.realtime.PeriodicParameters;
import lejos.realtime.PriorityParameters;
import lejos.realtime.ProcessingGroupParameters;
import lejos.realtime.RealtimeThread;
import lejos.realtime.ReleaseParameters;
import lejos.realtime.Schedulable;
import lejos.realtime.Scheduler;
import lejos.realtime.SchedulingParameters;

public class PriorityScheduler
extends Scheduler {
    protected final ArrayList<Schedulable> feasabilityList = new ArrayList();
    protected static PriorityScheduler current = null;
    protected final String policy;

    protected PriorityScheduler() {
        this.policy = "PriorityScheduler";
    }

    protected PriorityScheduler(String policy) {
        this.policy = policy;
    }

    public static PriorityScheduler instance() {
        if (current == null) {
            current = new PriorityScheduler();
        }
        return current;
    }

    public int getMaxPriority() {
        return 99;
    }

    public static int getMaxPriority(Thread thread) {
        return 10;
    }

    public int getMinPriority() {
        return 10;
    }

    public static int getMinPriority(Thread thread) {
        return 1;
    }

    public int getNormPriority() {
        return 25;
    }

    public static int getNormPriority(Thread thread) {
        return 5;
    }

    public boolean isFeasible() {
        ArrayList[] allThreads = new ArrayList[this.getMaxPriority() + 1];
        for (int i = 0; i < allThreads.length; ++i) {
            allThreads[i] = new ArrayList();
        }
        float u = 0.0f;
        int n = this.feasabilityList.size();
        if (n == 0) {
            return true;
        }
        int wt = 0;
        int t = 1;
        for (Schedulable schedulable : this.feasabilityList) {
            if (!(schedulable instanceof RealtimeThread)) continue;
            RealtimeThread rtThread = (RealtimeThread)schedulable;
            int priority = PriorityScheduler.getThreadPriority(rtThread);
            allThreads[priority].add(rtThread);
            float utmp = (float)PriorityScheduler.getThreadCost(rtThread) / (float)PriorityScheduler.getThreadDeadline(rtThread);
            u += utmp;
        }
        if (u > 1.0f) {
            return false;
        }
        if ((double)u < (double)n * (Math.pow(2.0, 1.0 / (double)n) - 1.0)) {
            return true;
        }
        for (Schedulable s : this.feasabilityList) {
            int priority = 0;
            if (!(s instanceof RealtimeThread)) continue;
            RealtimeThread rtThread = (RealtimeThread)s;
            priority = PriorityScheduler.getThreadPriority(rtThread);
            while (wt != t) {
                t = wt;
                wt = PriorityScheduler.getWorkTime(allThreads, priority, t);
            }
            int q = (int)Math.ceil((long)wt / PriorityScheduler.getThreadPeriod(rtThread));
            t = 1;
            wt = 0;
            int[] ct = new int[q];
            for (int m = 1; m <= q; ++m) {
                while (wt != t) {
                    t = wt;
                    wt = PriorityScheduler.getWorkTimeForResponseTime(allThreads, priority, t, rtThread, m);
                }
                ct[m - 1] = wt - m * (int)PriorityScheduler.getThreadPeriod(rtThread);
            }
            int r = ct[0];
            for (int i = 1; i < q; ++i) {
                if (ct[i] <= r) continue;
                r = ct[i];
            }
            if ((long)r <= PriorityScheduler.getThreadDeadline(rtThread)) continue;
            return false;
        }
        return false;
    }

    public boolean setIfFeasible(Schedulable schedulable, ReleaseParameters release, MemoryParameters memory) {
        boolean ret = this.addToFeasibility(schedulable);
        if (!ret) {
            this.removeFromFeasibility(schedulable);
        }
        return ret;
    }

    public boolean setIfFeasible(Schedulable schedulable, ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group) {
        boolean ret = this.addToFeasibility(schedulable);
        if (!ret) {
            this.removeFromFeasibility(schedulable);
        }
        return ret;
    }

    public boolean setIfFeasible(Schedulable schedulable, SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group) {
        boolean ret = this.addToFeasibility(schedulable);
        if (!ret) {
            this.removeFromFeasibility(schedulable);
        }
        return ret;
    }

    protected boolean addToFeasibility(Schedulable schedulable) {
        this.feasabilityList.add(schedulable);
        return this.isFeasible();
    }

    protected boolean removeFromFeasibility(Schedulable schedulable) {
        if (schedulable == null) {
            throw new IllegalArgumentException("This schedulable object is null");
        }
        return this.feasabilityList.remove(schedulable);
    }

    public void fireSchedulable(Schedulable schedulable) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getPolicyName() {
        return this.policy;
    }

    protected static int getThreadPriority(RealtimeThread rt) {
        if (rt.getSchedulingParameters() instanceof PriorityParameters) {
            PriorityParameters priorityParams = (PriorityParameters)rt.getSchedulingParameters();
            return priorityParams.getPriority();
        }
        throw new IllegalArgumentException("No priority available for this thread");
    }

    protected static long getThreadCost(RealtimeThread rt) {
        long cost = (long)rt.getReleaseParameters().getCost().getNanoseconds() + rt.getReleaseParameters().getCost().getMilliseconds();
        return cost;
    }

    protected static long getThreadPeriod(RealtimeThread rt) {
        if (rt.getReleaseParameters() instanceof PeriodicParameters) {
            PeriodicParameters periodParams = (PeriodicParameters)rt.getReleaseParameters();
            long period = (long)periodParams.getPeriod().getNanoseconds() + periodParams.getPeriod().getMilliseconds();
            return period;
        }
        throw new IllegalArgumentException("No PeriodicParameters for this RealtimeThread");
    }

    protected static long getThreadDeadline(RealtimeThread rt) {
        long deadline = (long)rt.getReleaseParameters().getDeadline().getNanoseconds() + rt.getReleaseParameters().getDeadline().getMilliseconds();
        return deadline;
    }

    protected static int getWorkTime(ArrayList[] lists, int priority, int t) {
        int wt = 0;
        for (int n = lists.length; n >= priority; --n) {
            ArrayList list = lists[n];
            for (Object o : list) {
                RealtimeThread rt = (RealtimeThread)o;
                wt = (int)((double)wt + Math.ceil((long)t / PriorityScheduler.getThreadPeriod(rt)) * (double)PriorityScheduler.getThreadCost(rt));
            }
        }
        return wt;
    }

    protected static int getWorkTimeForResponseTime(ArrayList[] lists, int priority, int t, RealtimeThread rt, int m) {
        int wt = 0;
        for (int n = lists.length; n >= priority + 1; --n) {
            ArrayList list = lists[n];
            for (Object o : list) {
                RealtimeThread rtCurrent = (RealtimeThread)o;
                wt = (int)((double)wt + Math.ceil((long)t / PriorityScheduler.getThreadPeriod(rtCurrent)) * (double)PriorityScheduler.getThreadCost(rtCurrent));
            }
        }
        wt = (int)((long)wt + (long)m * PriorityScheduler.getThreadCost(rt));
        return wt;
    }
}

