/*
 * Decompiled with CFR 0.152.
 */
package lejos.realtime;

import lejos.realtime.AsyncEventHandler;
import lejos.realtime.HighResolutionTime;
import lejos.realtime.RelativeTime;
import lejos.realtime.ReleaseParameters;

public class PeriodicParameters
extends ReleaseParameters {
    private HighResolutionTime start;
    private RelativeTime period;

    public PeriodicParameters(RelativeTime period) {
        this(null, period, null, null, null, null);
    }

    public PeriodicParameters(HighResolutionTime start, RelativeTime period) {
        this(start, period, null, null, null, null);
    }

    public PeriodicParameters(HighResolutionTime start, RelativeTime period, RelativeTime cost, RelativeTime deadline, AsyncEventHandler overrunHandler, AsyncEventHandler missHandler) {
        super(cost, deadline, overrunHandler, missHandler);
        this.setPeriod(period);
        this.setStart(start);
        this.setDeadline(deadline);
    }

    public RelativeTime getPeriod() {
        return this.period;
    }

    public HighResolutionTime getStart() {
        return this.start;
    }

    public void setDeadline(RelativeTime deadline) {
        if (deadline == null) {
            deadline = this.period;
        }
        super.setDeadline(deadline);
    }

    public boolean setIfFeasible(RelativeTime period, RelativeTime cost, RelativeTime deadline) {
        throw new UnsupportedOperationException("Not overrided yet.");
    }

    public void setPeriod(RelativeTime period) {
        if (period == null) {
            throw new IllegalArgumentException("Period must not be null.");
        }
        this.period = period;
    }

    public void setStart(HighResolutionTime start) {
        if (start == null) {
            start = new RelativeTime(0L, 0);
        }
        this.start = start;
    }
}

