/*
 * Decompiled with CFR 0.152.
 */
package lejos.realtime;

import java.util.ArrayList;
import lejos.realtime.PriorityScheduler;
import lejos.realtime.RealtimeThread;
import lejos.realtime.Schedulable;

public class DMScheduler
extends PriorityScheduler {
    protected DMScheduler() {
        super("DMScheduler");
    }

    public static PriorityScheduler instance() {
        if (current == null) {
            current = new DMScheduler();
        }
        if (DMScheduler.current.policy != "DMScheduler") {
            current = new DMScheduler();
        }
        return current;
    }

    public boolean isFeasible() {
        ArrayList[] allThreads = new ArrayList[this.getMaxPriority() + 1];
        for (int i = 0; i < allThreads.length; ++i) {
            allThreads[i] = new ArrayList();
        }
        float u = 0.0f;
        int n = this.feasabilityList.size();
        if (n == 0) {
            return true;
        }
        int wt = 0;
        int t = 1;
        for (Schedulable schedulable : this.feasabilityList) {
            if (!(schedulable instanceof RealtimeThread)) continue;
            RealtimeThread rtThread = (RealtimeThread)schedulable;
            int priority = DMScheduler.getThreadPriority(rtThread);
            allThreads[priority].add(rtThread);
            float utmp = (float)DMScheduler.getThreadCost(rtThread) / (float)DMScheduler.getThreadDeadline(rtThread);
            u += utmp;
        }
        if (u > 1.0f) {
            return false;
        }
        if ((double)u < (double)n * (Math.pow(2.0, 1.0 / (double)n) - 1.0)) {
            return true;
        }
        for (Schedulable s : this.feasabilityList) {
            int priority = 0;
            if (!(s instanceof RealtimeThread)) continue;
            RealtimeThread rtThread = (RealtimeThread)s;
            priority = DMScheduler.getThreadPriority(rtThread);
            while (wt != t) {
                t = wt;
                wt = DMScheduler.getWorkTime(allThreads, priority, t);
            }
            int q = (int)Math.ceil((long)wt / DMScheduler.getThreadPeriod(rtThread));
            t = 1;
            wt = 0;
            int[] ct = new int[q];
            for (int m = 1; m <= q; ++m) {
                while (wt != t) {
                    t = wt;
                    wt = DMScheduler.getWorkTimeForResponseTime(allThreads, priority, t, rtThread, m);
                }
                ct[m - 1] = wt - m * (int)DMScheduler.getThreadPeriod(rtThread);
            }
            int r = ct[0];
            for (int i = 1; i < q; ++i) {
                if (ct[i] <= r) continue;
                r = ct[i];
            }
            if ((long)r <= DMScheduler.getThreadDeadline(rtThread)) continue;
            return false;
        }
        return false;
    }
}

