/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.comm.NXTCommConnector;
import lejos.nxt.comm.NXTCommDevice;
import lejos.nxt.comm.NXTConnection;
import lejos.nxt.comm.USBConnection;
import lejos.util.Delay;

public class USB
extends NXTCommDevice {
    public static final int RESET = 0x40000000;
    static final int BUFSZ = 64;
    static final int USB_STREAM = 1;
    static final int USB_STATE_MASK = -268435456;
    static final int USB_STATE_CONNECTED = 0x10000000;
    static final int USB_CONFIG_MASK = 0xF000000;
    static final int USB_WRITABLE = 0x100000;
    static final int USB_READABLE = 0x200000;
    private static final byte SYSTEM_COMMAND_REPLY = 1;
    private static final byte REPLY_COMMAND = 2;
    private static final byte GET_FIRMWARE_VERSION = -120;
    private static final byte GET_DEVICE_INFO = -101;
    private static final byte NXJ_PACKET_MODE = -1;
    static NXTCommConnector connector;

    private USB() {
    }

    private static void flushInput(NXTConnection conn) {
        conn.discardInput();
    }

    private static boolean isConnected(NXTConnection conn, byte[] cmd) {
        int len = 3;
        boolean ret = false;
        if (conn.available() < 2) {
            return false;
        }
        if (conn.read(cmd, cmd.length, false) >= 2 && cmd[0] == 1) {
            cmd[2] = -1;
            if (cmd[1] == -120) {
                cmd[2] = 0;
                cmd[3] = 2;
                cmd[4] = 1;
                cmd[5] = 3;
                cmd[6] = 1;
                len = 7;
            }
            if (cmd[1] == -101) {
                cmd[2] = 0;
                for (int i = 0; i < devName.length(); ++i) {
                    cmd[3 + i] = (byte)devName.charAt(i);
                }
                len = 33;
            }
            if (cmd[1] == -1) {
                cmd[1] = -2;
                cmd[2] = -17;
                ret = true;
                len = 3;
            }
            cmd[0] = 2;
            conn.write(cmd, len, false);
        }
        return ret;
    }

    public static USBConnection waitForConnection(int timeout, int mode) {
        byte[] buf = new byte[64];
        USBConnection conn = new USBConnection(2);
        USB.usbSetName(devName);
        USB.usbSetSerialNo(devAddress);
        USB.usbEnable((mode & 0x40000000) != 0 ? 1 : 0);
        mode &= 0xBFFFFFFF;
        USB.flushInput(conn);
        if (timeout == 0) {
            timeout = Integer.MAX_VALUE;
        }
        while (timeout-- > 0) {
            int status = USB.usbStatus();
            if ((status & 0xF0000000) == 0x10000000 && (status & 0xF000000) != 0 && (mode == 2 || mode == 1 && (status & 0x300000) == 0x300000 || mode == 0 && USB.isConnected(conn, buf))) {
                conn.setIOMode(mode);
                return conn;
            }
            Delay.msDelay(1L);
        }
        USB.usbDisable();
        return null;
    }

    public static USBConnection waitForConnection() {
        return USB.waitForConnection(0, 0);
    }

    public static void waitForDisconnect(USBConnection conn, int timeout) {
        while (timeout-- > 0) {
            USB.flushInput(conn);
            int status = USB.usbStatus();
            if ((status & 0xF0000000) != 0x10000000 || (status & 0xF000000) == 0) break;
            Delay.msDelay(1L);
        }
        USB.usbDisable();
    }

    public static native void usbEnable(int var0);

    public static native void usbDisable();

    public static native void usbReset();

    public static native int usbRead(byte[] var0, int var1, int var2);

    public static native int usbWrite(byte[] var0, int var1, int var2);

    public static native int usbStatus();

    public static native void usbSetSerialNo(String var0);

    public static native void usbSetName(String var0);

    public static NXTCommConnector getConnector() {
        if (connector == null) {
            connector = new Connector();
        }
        return connector;
    }

    static {
        USB.loadSettings();
        connector = null;
    }

    static class Connector
    extends NXTCommConnector {
        Connector() {
        }

        public NXTConnection connect(String target, int mode) {
            return null;
        }

        public NXTConnection waitForConnection(int timeout, int mode) {
            return USB.waitForConnection(timeout, mode);
        }
    }
}

