/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.IOException;
import java.io.InputStream;
import lejos.nxt.comm.NXTConnection;

public class NXTInputStream
extends InputStream {
    private byte[] buf;
    private int bufIdx = 0;
    private int bufSize = 0;
    private NXTConnection conn = null;

    NXTInputStream(NXTConnection conn, int buffSize) {
        this.conn = conn;
        this.buf = new byte[buffSize];
    }

    public int read() throws IOException {
        if (this.bufIdx >= this.bufSize) {
            this.bufSize = 0;
        }
        if (this.bufSize <= 0) {
            this.bufSize = this.conn.read(this.buf, this.buf.length);
            if (this.bufSize < -1) {
                throw new IOException();
            }
            if (this.bufSize <= 0) {
                return -1;
            }
            this.bufIdx = 0;
        }
        return this.buf[this.bufIdx++] & 0xFF;
    }

    public int available() throws IOException {
        if (this.bufIdx >= this.bufSize) {
            this.bufSize = 0;
        }
        if (this.bufSize == 0) {
            this.bufIdx = 0;
            this.bufSize = this.conn.read(this.buf, this.buf.length, false);
            if (this.bufSize < -1) {
                throw new IOException();
            }
            if (this.bufSize < 0) {
                this.bufSize = 0;
            }
        }
        return this.bufSize - this.bufIdx;
    }

    public void close() {
        this.bufIdx = 0;
        this.bufSize = 0;
    }
}

