/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CPort;
import lejos.nxt.SensorConstants;

public class I2CSensor
implements SensorConstants {
    protected static byte VERSION = 0;
    protected static byte PRODUCT_ID = (byte)8;
    protected static byte SENSOR_TYPE = (byte)16;
    I2CPort port;
    int address = 1;
    String version = null;
    String productID = null;
    String sensorType = null;
    byte[] byteBuff = new byte[8];
    byte[] buf1 = new byte[1];

    public I2CSensor(I2CPort port, int mode) {
        this.port = port;
        port.i2cEnable(mode);
        port.setType(10);
    }

    public I2CSensor(I2CPort port) {
        this(port, 1);
    }

    public int getData(int register, byte[] buf, int len) {
        int ret = this.port.i2cStart(this.address, register, 1, null, len, 0);
        if (ret != 0) {
            return ret;
        }
        while (this.port.i2cBusy() != 0) {
            Thread.yield();
        }
        ret = this.port.i2cComplete(buf, len);
        return ret < 0 ? ret : (ret == len ? 0 : -1);
    }

    public int sendData(int register, byte[] buf, int len) {
        int ret = this.port.i2cStart(this.address, register, 1, buf, len, 1);
        if (ret != 0) {
            return ret;
        }
        while (this.port.i2cBusy() != 0) {
            Thread.yield();
        }
        return this.port.i2cComplete(null, 0);
    }

    public int sendData(int register, byte value) {
        this.buf1[0] = value;
        return this.sendData(register, this.buf1, 1);
    }

    public String getVersion() {
        return this.fetchString(VERSION, 8);
    }

    public String getProductID() {
        return this.fetchString(PRODUCT_ID, 8);
    }

    public String getSensorType() {
        return this.fetchString(SENSOR_TYPE, 8);
    }

    protected String fetchString(int register, int len) {
        int ret = this.getData(register, this.byteBuff, 8);
        char[] charBuff = new char[len];
        for (int i = 0; i < len; ++i) {
            charBuff[i] = (char)(this.byteBuff[i] == 0 ? 32 : (char)this.byteBuff[i]);
        }
        return new String(charBuff, 0, len);
    }

    public void setAddress(int addr) {
        this.address = addr;
    }

    public I2CPort getPort() {
        return this.port;
    }
}

