/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.BasicMotorPort;
import lejos.robotics.DCMotor;

public abstract class BasicMotor
implements DCMotor {
    final int FORWARD = 1;
    final int BACKWARD = 2;
    final int STOP = 3;
    final int FLOAT = 4;
    int _mode = 4;
    int _power = 50;
    protected BasicMotorPort _port;

    public void setPower(int power) {
        this._power = power;
        this._port.controlMotor(this._power, this._mode);
    }

    public int getPower() {
        return this._power;
    }

    public void forward() {
        this.updateState(1);
    }

    public boolean isForward() {
        return this._mode == 1;
    }

    public void backward() {
        this.updateState(2);
    }

    public boolean isBackward() {
        return this._mode == 2;
    }

    public void reverseDirection() {
        if (this._mode == 1) {
            this.updateState(2);
        } else if (this._mode == 2) {
            this.updateState(1);
        }
    }

    public boolean isMoving() {
        return this._mode == 1 || this._mode == 2;
    }

    public void flt() {
        this.updateState(4);
    }

    public boolean isFloating() {
        return this._mode == 4;
    }

    public void stop() {
        this.updateState(3);
    }

    public boolean isStopped() {
        return this._mode == 3;
    }

    void updateState(int mode) {
        if (this._mode != mode) {
            this._mode = mode;
            this._port.controlMotor(this._power, this._mode);
        }
    }

    public int getMode() {
        return this._mode;
    }
}

