/*
 * Decompiled with CFR 0.152.
 */
package lejos.charset;

import lejos.charset.CharsetDecoder;

public class UTF8Decoder
implements CharsetDecoder {
    private static final int MIN_NON_ASCII = 128;
    private static final int MIN_UTF8_SEQ2 = 192;
    private static final int MIN_UTF8_SEQ3 = 224;
    private static final int MIN_UTF8_SEQ4 = 240;
    private static final int MIN_UTF8_SEQ5 = 248;

    public int decode(byte[] source, int offset, int limit) {
        int first = source[offset] & 0xFF;
        if (first < 128) {
            return first;
        }
        if (first < 192 || first >= 248) {
            return 63;
        }
        int len = first < 224 ? 2 : (first < 240 ? 3 : 4);
        if (len > limit - offset) {
            return 63;
        }
        first &= 63 >> len;
        for (int i = 1; i < len; ++i) {
            byte b = source[offset + i];
            if ((b & 0xC0) != 128) {
                return 63;
            }
            first = first << 6 | b & 0x3F;
        }
        return first;
    }

    public int estimateByteCount(byte[] source, int offset, int limit) {
        if (offset >= limit) {
            return 1;
        }
        int first = source[offset] & 0xFF;
        if (first < 192 || first >= 248) {
            return 1;
        }
        int maxlen = limit - offset;
        int len = first < 224 ? 2 : (first < 240 ? 3 : 4);
        if (maxlen > len) {
            maxlen = len;
        }
        if (maxlen > 1 && (source[offset + 1] & 0xC0) != 128) {
            return 1;
        }
        if (maxlen > 2 && (source[offset + 2] & 0xC0) != 128) {
            return 2;
        }
        if (maxlen > 3 && (source[offset + 3] & 0xC0) != 128) {
            return 3;
        }
        if (len > maxlen) {
            return maxlen + 1;
        }
        return len;
    }

    public int getMaxCharLength() {
        return 4;
    }
}

