/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class TextField
extends Item {
    public static final int ANY = 1;
    public static final int EMAILADDR = 2;
    public static final int NUMERIC = 3;
    public static final int PHONENUMBER = 4;
    public static final int URL = 5;
    public static final int DECIMAL = 6;
    public static final int PASSWORD = 256;
    public static final int UNEDITABLE = 512;
    public static final int SENSITIVE = 768;
    public static final int NON_PREDICTIVE = 1024;
    public static final int INITIAL_CAPS_WORD = 1280;
    public static final int INITIAL_CAPS_SENTENCE = 1536;
    private String text;
    private int maxSize;
    private int constraints;

    public TextField(String label, String text, int maxSize, int constraints) {
        this.label = label;
        this.text = text;
        this.maxSize = maxSize;
        this.constraints = constraints;
        this.interactive = true;
        if (label != null) {
            this.minWidth = label.length() * 6;
            this.minHeight = 8;
        }
        if (text != null) {
            if (this.minWidth + text.length() * 6 < 100) {
                this.minWidth += text.length() * 6;
            } else {
                this.minWidth = Math.max(this.minWidth, text.length() * 6);
                this.minHeight += 8;
            }
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getConstraints() {
        return this.constraints;
    }

    public void paint(Graphics g, int x, int y, int w, int h, boolean selected) {
        if (this.label != null) {
            g.drawString(this.label, x, y);
            if (h <= 8) {
                x += this.label.length() * 6;
            } else {
                y += 8;
            }
        }
        g.drawString(this.text, x, y, selected);
    }
}

