/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

class StringUtils {
    private static final int STR_NAN_LEN = 3;
    private static final String STR_NAN = "NaN";
    private static final int STR_INFINITY_LEN = 8;
    private static final String STR_INFINITY = "Infinity";
    static final int MAX_FLOAT_CHARS = 15;
    static final int MAX_DOUBLE_CHARS = 25;
    private static final int STR_TO_DOUBLE_MAXEXP = 350;
    private static final int STR_TO_FLOAT_MAXEXP = 60;

    StringUtils() {
    }

    static int parseDigit(char c, int radix) {
        int r = Character.digit((int)c, radix);
        if (r < 0) {
            throw new NumberFormatException("illegal digit character");
        }
        return r;
    }

    static void throwNumberFormat(String s, int radix) {
        if (s == null) {
            throw new NumberFormatException("string is null");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("given radix is invalid");
        }
    }

    static int invalidRadixTo10(int radix) {
        if (radix < 2 || radix > 36) {
            return 10;
        }
        return radix;
    }

    static int getIntChars(char[] buf, int p, int v, int radix) {
        int v2 = v <= 0 ? v : -v;
        do {
            buf[--p] = Character.forDigit(-(v2 % radix), radix);
        } while ((v2 /= radix) != 0);
        if (v < 0) {
            buf[--p] = 45;
        }
        return p;
    }

    static int getLongChars(char[] buf, int p, long v, int radix) {
        long v2 = v <= 0L ? v : -v;
        do {
            buf[--p] = Character.forDigit(-((int)(v2 % (long)radix)), radix);
        } while ((v2 /= (long)radix) != 0L);
        if (v < 0L) {
            buf[--p] = 45;
        }
        return p;
    }

    static void reverseChars(char[] buf, int start, int end, int len) {
        len = Math.min(len, end - start >> 1);
        int end2 = start + len;
        int base = start + end - 1;
        for (int i = start; i < end2; ++i) {
            int j = base - i;
            char tmp = buf[i];
            buf[i] = buf[j];
            buf[j] = tmp;
        }
    }

    static int exactStringLength(int v, int radix) {
        int c = v < 0 ? 1 : 0;
        do {
            ++c;
        } while ((v /= radix) != 0);
        return c;
    }

    static int exactStringLength(long v, int radix) {
        int c = v < 0L ? 1 : 0;
        do {
            ++c;
        } while ((v /= (long)radix) != 0L);
        return c;
    }

    private static float pow10f_bf(float r, int e) {
        float[] b;
        if (e >= 0) {
            b = Pow10FConstants.POW10F_1;
        } else {
            b = Pow10FConstants.POW10F_2;
            e = -e;
        }
        if ((e & 0x20) != 0) {
            r *= b[5];
        }
        if ((e & 0x10) != 0) {
            r *= b[4];
        }
        if ((e & 8) != 0) {
            r *= b[3];
        }
        if ((e & 4) != 0) {
            r *= b[2];
        }
        if ((e & 2) != 0) {
            r *= b[1];
        }
        if ((e & 1) != 0) {
            r *= b[0];
        }
        return r;
    }

    private static float pow10f_sf(float r, int e) {
        float[] b;
        if (e >= 0) {
            b = Pow10FConstants.POW10F_1;
        } else {
            b = Pow10FConstants.POW10F_2;
            e = -e;
        }
        if ((e & 1) != 0) {
            r *= b[0];
        }
        if ((e & 2) != 0) {
            r *= b[1];
        }
        if ((e & 4) != 0) {
            r *= b[2];
        }
        if ((e & 8) != 0) {
            r *= b[3];
        }
        if ((e & 0x10) != 0) {
            r *= b[4];
        }
        if ((e & 0x20) != 0) {
            r *= b[5];
        }
        return r;
    }

    private static double pow10d_bf(double r, int e) {
        double[] b;
        if (e >= 0) {
            b = Pow10DConstants.POW10D_1;
        } else {
            b = Pow10DConstants.POW10D_2;
            e = -e;
        }
        if ((e & 0x100) != 0) {
            r *= b[8];
        }
        if ((e & 0x80) != 0) {
            r *= b[7];
        }
        if ((e & 0x40) != 0) {
            r *= b[6];
        }
        if ((e & 0x20) != 0) {
            r *= b[5];
        }
        if ((e & 0x10) != 0) {
            r *= b[4];
        }
        if ((e & 8) != 0) {
            r *= b[3];
        }
        if ((e & 4) != 0) {
            r *= b[2];
        }
        if ((e & 2) != 0) {
            r *= b[1];
        }
        if ((e & 1) != 0) {
            r *= b[0];
        }
        return r;
    }

    private static double pow10d_sf(double r, int e) {
        double[] b;
        if (e >= 0) {
            b = Pow10DConstants.POW10D_1;
        } else {
            b = Pow10DConstants.POW10D_2;
            e = -e;
        }
        if ((e & 1) != 0) {
            r *= b[0];
        }
        if ((e & 2) != 0) {
            r *= b[1];
        }
        if ((e & 4) != 0) {
            r *= b[2];
        }
        if ((e & 8) != 0) {
            r *= b[3];
        }
        if ((e & 0x10) != 0) {
            r *= b[4];
        }
        if ((e & 0x20) != 0) {
            r *= b[5];
        }
        if ((e & 0x40) != 0) {
            r *= b[6];
        }
        if ((e & 0x80) != 0) {
            r *= b[7];
        }
        if ((e & 0x100) != 0) {
            r *= b[8];
        }
        return r;
    }

    static int getDoubleChars(double x, char[] sb, int p) {
        int d;
        int exp;
        if (x != x) {
            STR_NAN.getChars(0, 3, sb, p);
            return p + 3;
        }
        long bits = Double.doubleToRawLongBits(x);
        if ((bits & Long.MIN_VALUE) != 0L) {
            sb[p++] = 45;
            x = -x;
        }
        if (x == 0.0) {
            sb[p] = 48;
            sb[p + 1] = 46;
            sb[p + 2] = 48;
            return p + 3;
        }
        if (x == Double.POSITIVE_INFINITY) {
            STR_INFINITY.getChars(0, 8, sb, p);
            return p + 8;
        }
        if (x >= Double.MIN_NORMAL) {
            exp = 62;
        } else {
            exp = 0;
            bits = Double.doubleToRawLongBits(x * 4.611686018427388E18);
        }
        exp += (int)(bits >> 52) & 0x7FF;
        exp = (exp * 631305 >> 21) - 327;
        x = StringUtils.pow10d_bf(x, 14 - exp);
        long tmp = 1000000000000000L;
        long digits = (long)(x + 0.5);
        if (digits >= tmp) {
            ++exp;
            digits = (long)(x * 0.1 + 0.5);
        }
        int leading = 0;
        if (exp > 0 && exp < 7) {
            leading = exp;
            exp = 0;
        }
        for (int i = 0; i <= leading; ++i) {
            int d2 = (int)(digits / (tmp /= 10L));
            sb[p++] = (char)(48 + d2);
            digits -= tmp * (long)d2;
        }
        sb[p++] = 46;
        do {
            d = (int)(digits / (tmp /= 10L));
            sb[p++] = (char)(48 + d);
        } while ((digits -= tmp * (long)d) > 0L);
        if (exp != 0) {
            sb[p++] = 69;
            if (exp < 0) {
                sb[p++] = 45;
                exp = -exp;
            }
            if (exp >= 100) {
                sb[p++] = (char)(exp / 100 + 48);
            }
            if (exp >= 10) {
                sb[p++] = (char)(exp / 10 % 10 + 48);
            }
            sb[p++] = (char)(exp % 10 + 48);
        }
        return p;
    }

    static int getFloatChars(float x, char[] sb, int p) {
        int d;
        int exp;
        if (x != x) {
            STR_NAN.getChars(0, 3, sb, p);
            return p + 3;
        }
        int bits = Float.floatToRawIntBits(x);
        if ((bits & Integer.MIN_VALUE) != 0) {
            sb[p++] = 45;
            x = -x;
        }
        if (x == 0.0f) {
            sb[p] = 48;
            sb[p + 1] = 46;
            sb[p + 2] = 48;
            return p + 3;
        }
        if (x == Float.POSITIVE_INFINITY) {
            STR_INFINITY.getChars(0, 8, sb, p);
            return p + 8;
        }
        if (x >= Float.MIN_NORMAL) {
            exp = 31;
        } else {
            exp = 0;
            bits = Float.floatToRawIntBits(x * 2.1474836E9f);
        }
        exp += bits >> 23 & 0xFF;
        exp = (exp * 5050455 >> 24) - 48;
        x = StringUtils.pow10f_bf(x, 6 - exp);
        int tmp = 10000000;
        int digits = (int)(x + 0.5f);
        if (digits >= tmp) {
            ++exp;
            digits = (int)(x * 0.1f + 0.5f);
        }
        int leading = 0;
        if (exp > 0 && exp < 6) {
            leading = exp;
            exp = 0;
        }
        for (int i = 0; i <= leading; ++i) {
            int d2 = digits / (tmp /= 10);
            sb[p++] = (char)(48 + d2);
            digits -= tmp * d2;
        }
        sb[p++] = 46;
        do {
            d = digits / (tmp /= 10);
            sb[p++] = (char)(48 + d);
        } while ((digits -= tmp * d) > 0);
        if (exp != 0) {
            sb[p++] = 69;
            if (exp < 0) {
                sb[p++] = 45;
                exp = -exp;
            }
            if (exp >= 10) {
                sb[p++] = (char)(exp / 10 + 48);
            }
            sb[p++] = (char)(exp % 10 + 48);
        }
        return p;
    }

    private static boolean checkString(String s, int p, String c) {
        int l = c.length();
        for (int i = 0; i < l; ++i) {
            if (s.charAt(p + i) == c.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static double stringToDouble(String s) {
        char c;
        boolean neg;
        int p;
        long r = 0L;
        int exp = 0;
        int l = s.length();
        if (l <= 0) {
            throw new NumberFormatException();
        }
        switch (s.charAt(0)) {
            case '-': {
                p = 1;
                neg = true;
                break;
            }
            case '+': {
                p = 1;
                neg = false;
                break;
            }
            default: {
                p = 0;
                neg = false;
            }
        }
        switch (l - p) {
            case 3: {
                if (!StringUtils.checkString(s, p, STR_NAN)) break;
                return Double.NaN;
            }
            case 8: {
                if (!StringUtils.checkString(s, p, STR_INFINITY)) break;
                return neg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        }
        boolean digits = false;
        while (p < l) {
            c = s.charAt(p);
            if (c < '0' || c > '9') {
                if (c == '.' || c == 'e' || c == 'E') break;
                throw new NumberFormatException();
            }
            digits = true;
            if (r <= 0xCCCCCCCCCCCCCCBL) {
                r = r * 10L + (long)(c - 48);
            } else {
                ++exp;
            }
            ++p;
        }
        if (p < l && s.charAt(p) == '.') {
            ++p;
            while (p < l) {
                c = s.charAt(p);
                if (c < '0' || c > '9') {
                    if (c == 'e' || c == 'E') break;
                    throw new NumberFormatException();
                }
                digits = true;
                if (r <= 0xCCCCCCCCCCCCCCBL) {
                    r = r * 10L + (long)(c - 48);
                    --exp;
                }
                ++p;
            }
        }
        if (!digits) {
            throw new NumberFormatException();
        }
        if (p < l) {
            boolean negexp;
            boolean digitsexp = false;
            if (++p < l) {
                switch (s.charAt(p)) {
                    case '-': {
                        negexp = true;
                        exp = -exp;
                        ++p;
                        break;
                    }
                    case '+': {
                        ++p;
                    }
                    default: {
                        negexp = false;
                        break;
                    }
                }
            } else {
                negexp = false;
            }
            int exp2 = 0;
            while (p < l) {
                char c2 = s.charAt(p);
                if (c2 < '0' || c2 > '9') {
                    throw new NumberFormatException();
                }
                digitsexp = true;
                if (exp2 + exp < 350) {
                    exp2 = exp2 * 10 + (c2 - 48);
                }
                ++p;
            }
            if (!digitsexp) {
                throw new NumberFormatException();
            }
            exp2 += exp;
            int n = exp = negexp ? -exp2 : exp2;
        }
        double r2 = exp < -350 ? 0.0 : (exp > 350 ? Double.POSITIVE_INFINITY : StringUtils.pow10d_sf(r, exp));
        return neg ? -r2 : r2;
    }

    static float stringToFloat(String s) {
        char c;
        boolean neg;
        int p;
        int r = 0;
        int exp = 0;
        int l = s.length();
        if (l <= 0) {
            throw new NumberFormatException();
        }
        switch (s.charAt(0)) {
            case '-': {
                p = 1;
                neg = true;
                break;
            }
            case '+': {
                p = 1;
                neg = false;
                break;
            }
            default: {
                p = 0;
                neg = false;
            }
        }
        switch (l - p) {
            case 3: {
                if (!StringUtils.checkString(s, p, STR_NAN)) break;
                return Float.NaN;
            }
            case 8: {
                if (!StringUtils.checkString(s, p, STR_INFINITY)) break;
                return neg ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
        }
        boolean digits = false;
        while (p < l) {
            c = s.charAt(p);
            if (c < '0' || c > '9') {
                if (c == '.' || c == 'e' || c == 'E') break;
                throw new NumberFormatException();
            }
            digits = true;
            if (r <= 0xCCCCCCB) {
                r = r * 10 + (c - 48);
            } else {
                ++exp;
            }
            ++p;
        }
        if (p < l && s.charAt(p) == '.') {
            ++p;
            while (p < l) {
                c = s.charAt(p);
                if (c < '0' || c > '9') {
                    if (c == 'e' || c == 'E') break;
                    throw new NumberFormatException();
                }
                digits = true;
                if (r <= 0xCCCCCCB) {
                    r = r * 10 + (c - 48);
                    --exp;
                }
                ++p;
            }
        }
        if (!digits) {
            throw new NumberFormatException();
        }
        if (p < l) {
            boolean negexp;
            boolean digitsexp = false;
            if (++p < l) {
                switch (s.charAt(p)) {
                    case '-': {
                        negexp = true;
                        exp = -exp;
                        ++p;
                        break;
                    }
                    case '+': {
                        ++p;
                    }
                    default: {
                        negexp = false;
                        break;
                    }
                }
            } else {
                negexp = false;
            }
            int exp2 = 0;
            while (p < l) {
                char c2 = s.charAt(p);
                if (c2 < '0' || c2 > '9') {
                    throw new NumberFormatException();
                }
                digitsexp = true;
                if (exp2 + exp < 60) {
                    exp2 = exp2 * 10 + (c2 - 48);
                }
                ++p;
            }
            if (!digitsexp) {
                throw new NumberFormatException();
            }
            exp2 += exp;
            int n = exp = negexp ? -exp2 : exp2;
        }
        float r2 = exp < -60 ? 0.0f : (exp > 60 ? Float.POSITIVE_INFINITY : StringUtils.pow10f_sf(r, exp));
        return neg ? -r2 : r2;
    }

    private static class Pow10DConstants {
        public static final double[] POW10D_1 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        public static final double[] POW10D_2 = new double[]{0.1, 0.01, 1.0E-4, 1.0E-8, 1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};

        private Pow10DConstants() {
        }
    }

    private static class Pow10FConstants {
        public static final float[] POW10F_1 = new float[]{10.0f, 100.0f, 10000.0f, 1.0E8f, 1.0E16f, 1.0E32f};
        public static final float[] POW10F_2 = new float[]{0.1f, 0.01f, 1.0E-4f, 1.0E-8f, 1.0E-16f, 1.0E-32f};

        private Pow10FConstants() {
        }
    }
}

