/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFERSIZE = 64;
    private static final int MIN_BUFFERSIZE = 1;
    private final byte[] buffer;
    private int offset;
    private int limit;

    public BufferedInputStream(InputStream out) {
        this(out, 64);
    }

    public BufferedInputStream(InputStream out, int size) {
        super(out);
        if (size < 1) {
            size = 1;
        }
        this.buffer = new byte[size];
    }

    public void close() throws IOException {
        this.limit = -1;
        this.in.close();
    }

    public int available() throws IOException {
        this.checkOpen();
        return this.limit - this.offset + this.in.available();
    }

    private void checkOpen() throws IOException {
        if (this.limit < 0) {
            throw new IOException("stream is closed");
        }
    }

    private boolean fillBuffer() throws IOException {
        if (this.offset >= this.limit) {
            int len = 0;
            while (len == 0) {
                len = this.in.read(this.buffer, 0, this.buffer.length);
            }
            if (len < 0) {
                return false;
            }
            this.offset = 0;
            this.limit = len;
        }
        return true;
    }

    public int read() throws IOException {
        this.checkOpen();
        if (!this.fillBuffer()) {
            return -1;
        }
        return this.buffer[this.offset++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        int blen = this.limit - this.offset;
        if (blen > 0) {
            if (blen > len) {
                blen = len;
            }
            System.arraycopy(this.buffer, this.offset, b, off, blen);
            this.offset += blen;
            return blen;
        }
        return this.in.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        int len;
        this.checkOpen();
        int blen = this.limit - this.offset;
        if (n <= (long)blen) {
            this.offset += (int)n;
            return n;
        }
        long norig = n;
        n -= (long)blen;
        this.offset = this.limit;
        while (n > 0L && (len = this.in.read(this.buffer, 0, this.buffer.length)) >= 0) {
            n -= (long)len;
        }
        return norig - n;
    }
}

