/*
 * Decompiled with CFR 0.152.
 */
package lejos.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import lejos.nxt.LCD;
import lejos.nxt.Sound;
import lejos.nxt.comm.Bluetooth;
import lejos.nxt.comm.NXTConnection;
import lejos.nxt.comm.USB;
import lejos.util.TextMenu;

public class Datalogger {
    private float[] log;
    private int _indx = 0;
    private int _size;

    public Datalogger() {
        this(512);
    }

    public Datalogger(int size) {
        this._size = size;
        this.log = new float[size];
    }

    public void writeLog(float v) {
        if (this._indx < this._size) {
            this.log[this._indx] = v;
            ++this._indx;
        }
    }

    public void reset() {
        this._indx = 0;
    }

    public void transmit() {
        NXTConnection connection = null;
        DataOutputStream dataOut = null;
        InputStream is = null;
        String[] items = new String[]{" USB", " Bluetooth"};
        TextMenu tm = new TextMenu(items, 2, "Transmit using");
        int s = tm.select();
        LCD.clear();
        if (s == 0) {
            LCD.drawString("wait for USB", 0, 0);
            connection = USB.waitForConnection();
        } else {
            LCD.drawString("wait for BT", 0, 0);
            connection = Bluetooth.waitForConnection();
        }
        try {
            is = connection.openInputStream();
            dataOut = connection.openDataOutputStream();
        }
        catch (Exception ie) {
            // empty catch block
        }
        LCD.drawString("connected", 0, 1);
        boolean more = true;
        while (more) {
            try {
                LCD.clear();
                LCD.drawString("Wait for Viewer", 0, 0);
                int b = 0;
                b = is.read();
                LCD.drawInt(b, 8, 1);
            }
            catch (IOException ie) {
                LCD.drawString("no connection", 0, 0);
            }
            LCD.clear();
            LCD.drawString("sending ", 0, 0);
            LCD.drawInt(this._indx, 4, 8, 0);
            try {
                dataOut.writeInt(this._indx);
                dataOut.flush();
                for (int i = 0; i < this._indx; ++i) {
                    dataOut.writeFloat(this.log[i]);
                }
                dataOut.flush();
                dataOut.close();
            }
            catch (IOException e) {
                LCD.drawString("write error", 0, 0);
                LCD.refresh();
            }
            LCD.clear();
            Sound.beepSequence();
            LCD.drawString("Sent " + this._indx, 0, 0);
            tm.setTitle("Resend?         ");
            String[] itms = new String[]{"Yes", "No"};
            tm.setItems(itms);
            more = 0 == tm.select();
        }
        try {
            dataOut.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void transmit(boolean useUSB) {
        this.transmit();
    }
}

