/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics;

import lejos.robotics.Pose;
import lejos.robotics.RotationPlatform;
import lejos.robotics.TachoMotor;

public class SimplePlatform
implements RotationPlatform {
    private TachoMotor directionMotor = null;
    private boolean invertDir = false;
    private float ratioDir = 1.0f;
    private int maxDir;
    private int minDir;

    public SimplePlatform(TachoMotor directionMotor) {
        this(directionMotor, false);
    }

    public SimplePlatform(TachoMotor directionMotor, boolean invertDir) {
        this(directionMotor, false, 1.0);
    }

    public SimplePlatform(TachoMotor directionMotor, boolean invertDir, double ratioDir) {
        this.directionMotor = directionMotor;
        this.invertDir = invertDir;
        this.ratioDir = (float)ratioDir;
    }

    public int getAbsoluteDirection(Pose pose) {
        return 0;
    }

    public int getDirection() {
        if (this.invertDir) {
            return (int)((float)(-this.directionMotor.getTachoCount()) * this.ratioDir);
        }
        return (int)((float)this.directionMotor.getTachoCount() * this.ratioDir);
    }

    public int getMaximumDirection() {
        return this.maxDir;
    }

    public int getMinimumDirection() {
        return this.minDir;
    }

    public int getRotationSpeed() {
        return (int)((float)this.directionMotor.getSpeed() / this.ratioDir);
    }

    public float getXOffset() {
        return 0.0f;
    }

    public float getYOffset() {
        return 0.0f;
    }

    public float getZOffset() {
        return 0.0f;
    }

    public void scanLeft() {
        this.setDirection(this.getMaximumDirection());
    }

    public void scanRight() {
        this.setDirection(this.getMinimumDirection());
    }

    public void setDirection(int angle) {
        if (this.invertDir) {
            angle = -angle;
        }
        this.directionMotor.rotateTo((int)((float)angle * this.ratioDir));
    }

    public void setMaximumDirection(int maxAngle) {
        this.maxDir = maxAngle;
    }

    public void setMinimumDirection(int minAngle) {
        this.minDir = minAngle;
    }

    public void setRotationSpeed(int speed) {
        this.directionMotor.setSpeed((int)((float)speed * this.ratioDir));
    }

    public void setXOffset() {
    }

    public void setYOffset() {
    }

    public void setZOffset() {
    }

    public void stopRotation() {
        this.directionMotor.stop();
    }

    public boolean zero() {
        return false;
    }
}

