/*
 * Decompiled with CFR 0.152.
 */
package lejos.realtime;

import lejos.realtime.EDFScheduler;
import lejos.realtime.MemoryParameters;
import lejos.realtime.PriorityScheduler;
import lejos.realtime.ProcessingGroupParameters;
import lejos.realtime.ReleaseParameters;
import lejos.realtime.Schedulable;
import lejos.realtime.SchedulingParameters;

public abstract class Scheduler {
    protected static final int FP = 1;
    protected static final int EDF = 2;

    protected static final native void setCurrentScheduler(int var0);

    protected static final native int getCurrentScheduler();

    protected Scheduler() {
    }

    public static Scheduler getDefaultScheduler() {
        int policy = Scheduler.getCurrentScheduler();
        if (policy == 1) {
            return PriorityScheduler.instance();
        }
        if (policy == 2) {
            return EDFScheduler.instance();
        }
        throw new NoSuchFieldError("Policy scheduler not found");
    }

    public static void setDefaultScheduler(Scheduler scheduler) {
        if (scheduler.getPolicyName().equals("EDF")) {
            Scheduler.setCurrentScheduler(2);
        } else if (scheduler.getPolicyName().equals("PriorityScheduler")) {
            Scheduler.setCurrentScheduler(1);
        } else {
            throw new IllegalArgumentException("Scheduler Policy doesn't exist");
        }
    }

    protected abstract boolean addToFeasibility(Schedulable var1);

    public abstract void fireSchedulable(Schedulable var1);

    public abstract String getPolicyName();

    public abstract boolean isFeasible();

    protected abstract boolean removeFromFeasibility(Schedulable var1);

    public abstract boolean setIfFeasible(Schedulable var1, ReleaseParameters var2, MemoryParameters var3);

    public abstract boolean setIfFeasible(Schedulable var1, ReleaseParameters var2, MemoryParameters var3, ProcessingGroupParameters var4);

    public abstract boolean setIfFeasible(Schedulable var1, SchedulingParameters var2, ReleaseParameters var3, MemoryParameters var4, ProcessingGroupParameters var5);
}

