/*
 * Decompiled with CFR 0.152.
 */
package lejos.realtime;

import lejos.realtime.AperiodicParameters;
import lejos.realtime.AsyncEventHandler;
import lejos.realtime.IllegalAssignmentError;
import lejos.realtime.MemoryArea;
import lejos.realtime.MemoryParameters;
import lejos.realtime.PeriodicParameters;
import lejos.realtime.PriorityParameters;
import lejos.realtime.ProcessingGroupParameters;
import lejos.realtime.ReleaseParameters;
import lejos.realtime.Schedulable;
import lejos.realtime.Scheduler;
import lejos.realtime.SchedulingParameters;

public class RealtimeThread
extends Thread
implements Schedulable {
    public static final int MIN_PRIORITY = 10;
    public static final int NORM_PRIORITY = 25;
    public static final int MAX_PRIORITY = 99;
    public static final int GC_MEM = 0;
    public static final int IMMORTAL_MEM = 1;
    private RealtimeThread _TVM_nextRealtimeThread;
    private int _TVM_start;
    private int _TVM_period;
    private int _TVM_cost;
    private int _TVM_deadline;
    private int _TVM_startPeriod;
    private int _TVM_remainingCost;
    private int _TVM_endDeadline;
    private AsyncEventHandler _TVM_costOverrunHandler;
    private AsyncEventHandler _TVM_deadlineMissHandler;
    private byte _TVM_memoryType;
    private byte _TVM_started;
    private ReleaseParameters release;
    private SchedulingParameters scheduling;
    private MemoryParameters memoryParameters;

    public RealtimeThread() {
        this(null, null, null, null, null, null);
    }

    public RealtimeThread(SchedulingParameters scheduling) {
        this(scheduling, null, null, null, null, null);
    }

    public RealtimeThread(SchedulingParameters scheduling, ReleaseParameters release) {
        this(scheduling, release, null, null, null, null);
    }

    public RealtimeThread(SchedulingParameters prio, ReleaseParameters release, MemoryParameters memoryParam, MemoryArea memoryArea) {
        this(prio, release);
        if (memoryParam != null || memoryArea != null) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public RealtimeThread(SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memory, MemoryArea area, ProcessingGroupParameters group, Runnable logic) {
        if (memory != null || area != null || group != null || logic != null) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.setSchedulingParameters(scheduling);
        this.setReleaseParameters(release);
    }

    public void run() {
        throw new UnsupportedOperationException("Not overrided yet.");
    }

    public void setReleaseParameters(ReleaseParameters release) throws IllegalArgumentException, IllegalStateException {
        if (release == null) {
            release = new AperiodicParameters();
        }
        if (release instanceof PeriodicParameters) {
            PeriodicParameters pp = (PeriodicParameters)release;
            this.rt_set_start((int)pp.getStart().getMilliseconds());
            this.rt_set_period((int)pp.getPeriod().getMilliseconds());
        }
        this.rt_set_cost((int)release.getCost().getMilliseconds());
        this.rt_set_deadline((int)release.getDeadline().getMilliseconds());
        this.rt_set_deadlineMissHandler(release.getDeadlineMissHandler());
        this.rt_set_costOverrunHandler(release.getCostOverrunHandler());
        this.release = release;
    }

    public void setSchedulingParameters(SchedulingParameters scheduling) throws IllegalArgumentException, IllegalAssignmentError {
        if (scheduling == null) {
            scheduling = new PriorityParameters(25);
        }
        if (scheduling instanceof PriorityParameters) {
            int prio = ((PriorityParameters)scheduling).getPriority();
            if (10 > prio || 99 < prio) {
                throw new IllegalArgumentException("priority must be between 10 and 99");
            }
            super.set_priority(prio);
        }
        this.scheduling = scheduling;
    }

    public void start() {
        this.init_rt_thread(0);
    }

    public boolean addIfFeasible() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean addToFeasibility() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MemoryParameters getMemoryParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ProcessingGroupParameters getProcessingGroupParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ReleaseParameters getReleaseParameters() {
        return this.release;
    }

    public Scheduler getScheduler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SchedulingParameters getSchedulingParameters() {
        return this.scheduling;
    }

    public final void schedulePeriodic() {
        this.schedule_periodic();
    }

    public boolean removeFromFeasibility() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private final native void init_rt_thread(int var1);

    private final native void prepare_2_wait();

    private final native void schedule_periodic();

    public final native void rt_set_start(int var1);

    public final native void rt_set_period(int var1);

    public final native void rt_set_cost(int var1);

    public final native void rt_set_deadline(int var1);

    public final native void rt_set_costOverrunHandler(AsyncEventHandler var1);

    public final native void rt_set_deadlineMissHandler(AsyncEventHandler var1);

    public boolean setIfFeasible(ReleaseParameters release, MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean setIfFeasible(ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean setIfFeasible(ReleaseParameters release, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean setIfFeasible(SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean setIfFeasible(SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memory, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMemoryParameters(MemoryParameters memory) {
        this.memoryParameters = memory;
    }

    public boolean setMemoryParametersIfFeasible(MemoryParameters memory) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setProcessingGroupParameters(ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean setProcessingGroupParametersIfFeasible(ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean setReleaseParametersIfFeasible(ReleaseParameters release) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setScheduler(Scheduler scheduler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setScheduler(Scheduler scheduler, SchedulingParameters scheduling, ReleaseParameters release, MemoryParameters memoryParameters, ProcessingGroupParameters group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean setSchedulingParametersIfFeasible(SchedulingParameters scheduling) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean waitForNextPeriod() {
        this.prepare_2_wait();
        return true;
    }
}

