/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.remote;

import java.io.IOException;
import lejos.nxt.remote.NXTCommand;
import lejos.nxt.remote.NXTProtocol;
import lejos.nxt.remote.OutputState;
import lejos.robotics.TachoMotor;

public class RemoteMotor
implements TachoMotor,
NXTProtocol {
    private int id;
    private byte power;
    private int mode;
    private int regulationMode;
    public byte turnRatio;
    private int runState;
    private boolean _rotating = false;
    private NXTCommand nxtCommand;

    public RemoteMotor(NXTCommand nxtCommand, int id) {
        this.id = id;
        this.power = (byte)80;
        this.mode = 6;
        this.regulationMode = 1;
        this.turnRatio = 0;
        this.runState = 0;
        this.nxtCommand = nxtCommand;
    }

    public final char getId() {
        char port = 'A';
        switch (this.id) {
            case 0: {
                port = 'A';
                break;
            }
            case 1: {
                port = 'B';
                break;
            }
            case 2: {
                port = 'C';
            }
        }
        return port;
    }

    public void forward() {
        this.runState = 32;
        try {
            this.nxtCommand.setOutputState(this.id, this.power, this.mode + 1, this.regulationMode, this.turnRatio, this.runState, 0);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public void backward() {
        this.runState = 32;
        try {
            this.nxtCommand.setOutputState(this.id, -this.power, this.mode + 1, this.regulationMode, this.turnRatio, this.runState, 0);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public void setSpeed(int speed) {
        if (speed > 900 | speed < 0) {
            return;
        }
        speed = speed * 100 / 900;
        this.power = (byte)speed;
    }

    public void setPower(int power) {
        this.power = (byte)power;
    }

    public int getSpeed() {
        return this.power * 900 / 100;
    }

    public int getPower() {
        return this.power;
    }

    public int getTachoCount() {
        try {
            OutputState state = this.nxtCommand.getOutputState(this.id);
            return state.rotationCount;
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
    }

    @Deprecated
    public int getRotationCount() {
        return this.getTachoCount();
    }

    @Deprecated
    public int getBlockTacho() {
        try {
            OutputState state = this.nxtCommand.getOutputState(this.id);
            return state.blockTachoCount;
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return 0;
        }
    }

    public void rotate(int count, boolean returnNow) {
        this.runState = 32;
        boolean status = false;
        try {
            if (count > 0) {
                this.nxtCommand.setOutputState(this.id, this.power, this.mode + 1, this.regulationMode, this.turnRatio, this.runState, count);
            } else {
                this.nxtCommand.setOutputState(this.id, -this.power, this.mode + 1, this.regulationMode, this.turnRatio, this.runState, Math.abs(count));
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        if (!returnNow) {
            while (this.isMoving()) {
                Thread.yield();
            }
        }
    }

    public boolean isMoving() {
        try {
            OutputState o = this.nxtCommand.getOutputState(this.id);
            return o.runState != 0;
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return false;
        }
    }

    public boolean isRotating() {
        return this._rotating;
    }

    public void rotate(int count) {
        this.rotate(count, false);
    }

    public void setRegulationMode(int mode) {
        this.regulationMode = mode;
    }

    public void rotateTo(int limitAngle) {
        this.rotateTo(limitAngle, false);
    }

    public void rotateTo(int limitAngle, boolean returnNow) {
        int tachometer = this.getTachoCount();
        this.rotate(limitAngle - tachometer, returnNow);
    }

    public void resetTachoCount() {
        try {
            this.nxtCommand.resetMotorPosition(this.id, false);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    @Deprecated
    public int resetBlockTacho() {
        try {
            this.nxtCommand.resetMotorPosition(this.id, true);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
        return 0;
    }

    public void stop() {
        this.runState = 32;
        try {
            this.nxtCommand.setOutputState(this.id, (byte)0, 7, this.regulationMode, this.turnRatio, this.runState, 0);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public void flt() {
        this.runState = 0;
        this.mode = 0;
        try {
            this.nxtCommand.setOutputState(this.id, (byte)0, 0, this.regulationMode, this.turnRatio, this.runState, 0);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public void regulateSpeed(boolean yes) {
    }

    public void smoothAcceleration(boolean yes) {
    }

    public int getRotationSpeed() {
        return this.getSpeed();
    }
}

