/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import lejos.nxt.LegacySensorPort;
import lejos.nxt.SensorConstants;
import lejos.robotics.Tachometer;
import lejos.util.Delay;

public class RCXRotationSensor
extends Thread
implements Tachometer,
SensorConstants {
    public static final int ONE_ROTATION = 16;
    protected static final int UPDATE_TIME = 2;
    protected LegacySensorPort port;
    protected int count;
    protected final Reader reader;
    private int speed = 0;
    private long previous_time = System.currentTimeMillis();
    protected static final int[][] inc = new int[][]{{0, 1, -1, 0}, {-1, 0, 0, 1}, {1, 0, 0, -1}, {0, -1, 1, 0}};

    public RCXRotationSensor(LegacySensorPort port) {
        this.port = port;
        port.setTypeAndMode(4, 0);
        this.reader = new Reader();
        this.reader.setDaemon(true);
        this.reader.setPriority(10);
        this.reader.start();
        this.count = 0;
    }

    protected int getPhase() {
        int val = this.port.readRawValue();
        if (val < 450) {
            return 0;
        }
        if (val < 675) {
            return 1;
        }
        if (val < 911) {
            return 2;
        }
        return 3;
    }

    public int getTachoCount() {
        return 360 * this.count / 16;
    }

    public int getRawTachoCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTachoCount() {
        Reader reader = this.reader;
        synchronized (reader) {
            this.count = 0;
        }
    }

    public int getRotationSpeed() {
        return this.speed;
    }

    protected class Reader
    extends Thread {
        protected Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int prev;
            int cur1 = prev = RCXRotationSensor.this.getPhase();
            while (true) {
                int cur2;
                if (cur1 == (cur2 = RCXRotationSensor.this.getPhase()) && cur2 != prev) {
                    Reader reader = this;
                    synchronized (reader) {
                        RCXRotationSensor.this.count += inc[prev][cur2];
                        int time_elapsed = (int)(System.currentTimeMillis() - RCXRotationSensor.this.previous_time);
                        RCXRotationSensor.this.speed = 360000 / (time_elapsed * 16);
                        RCXRotationSensor.this.previous_time = System.currentTimeMillis();
                    }
                    prev = cur2;
                }
                cur1 = cur2;
                Delay.msDelay(2L);
            }
        }
    }
}

