/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import lejos.nxt.LegacySensorPort;
import lejos.nxt.SensorConstants;
import lejos.robotics.Colors;
import lejos.robotics.LampLightDetector;

public class RCXLightSensor
implements SensorConstants,
LampLightDetector {
    LegacySensorPort port;
    private int _zero = 1023;
    private int _hundred = 0;
    private boolean floodlight = false;

    public RCXLightSensor(LegacySensorPort port) {
        this.port = port;
        port.setTypeAndMode(3, 128);
        this.setFloodlight(true);
    }

    @Deprecated
    public void activate() {
        this.setFloodlight(true);
    }

    @Deprecated
    public void passivate() {
        this.setFloodlight(false);
    }

    @Deprecated
    public int readValue() {
        return this.getLightValue();
    }

    public Colors.Color getFloodlight() {
        if (this.floodlight) {
            return Colors.Color.RED;
        }
        return Colors.Color.NONE;
    }

    public boolean isFloodlightOn() {
        return this.floodlight;
    }

    public void setFloodlight(boolean floodlight) {
        this.floodlight = floodlight;
        if (floodlight) {
            this.port.activate();
        } else {
            this.port.passivate();
        }
    }

    public boolean setFloodlight(Colors.Color color) {
        if (color == Colors.Color.RED) {
            this.setFloodlight(true);
            return true;
        }
        if (color == Colors.Color.NONE) {
            this.setFloodlight(false);
            return true;
        }
        return false;
    }

    public int getLightValue() {
        return (1023 - this.port.readRawValue()) * 100 / 1023;
    }

    public int getNormalizedLightValue() {
        return 1023 - this.port.readRawValue();
    }

    public void calibrateLow() {
        this._zero = this.port.readRawValue();
    }

    public void calibrateHigh() {
        this._hundred = this.port.readRawValue();
    }

    public void setLow(int low) {
        this._zero = 1023 - low;
    }

    public void setHigh(int high) {
        this._hundred = 1023 - high;
    }

    public int getLow() {
        return 1023 - this._zero;
    }

    public int getHigh() {
        return 1023 - this._hundred;
    }
}

