/*
 * Decompiled with CFR 0.152.
 */
package lejos.charset;

import lejos.charset.CharsetEncoder;

public class UTF8Encoder
implements CharsetEncoder {
    public int getMaxCharLength() {
        return 4;
    }

    public int encode(int codepoint, byte[] target, int offset) {
        if (codepoint < 0 || codepoint > 0x1FFFFF) {
            target[offset++] = 63;
        } else if (codepoint <= 127) {
            target[offset++] = (byte)codepoint;
        } else if (codepoint <= 2047) {
            target[offset++] = (byte)(codepoint >> 6 | 0xC0);
            target[offset++] = (byte)(codepoint & 0x3F | 0x80);
        } else if (codepoint <= 65535) {
            target[offset++] = (byte)(codepoint >> 12 | 0xE0);
            target[offset++] = (byte)(codepoint >> 6 & 0x3F | 0x80);
            target[offset++] = (byte)(codepoint & 0x3F | 0x80);
        } else {
            target[offset++] = (byte)(codepoint >> 18 | 0xF0);
            target[offset++] = (byte)(codepoint >> 12 & 0x3F | 0x80);
            target[offset++] = (byte)(codepoint >> 6 & 0x3F | 0x80);
            target[offset++] = (byte)(codepoint & 0x3F | 0x80);
        }
        return offset;
    }

    public int estimateByteCount(int codepoint) {
        if (codepoint <= 127 || codepoint > 0x1FFFFF) {
            return 1;
        }
        if (codepoint <= 2047) {
            return 2;
        }
        if (codepoint <= 65535) {
            return 3;
        }
        return 4;
    }
}

