/*
 * Decompiled with CFR 0.152.
 */
package lejos.addon.gps;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import lejos.addon.gps.NMEASentence;

public class RMCSentence
extends NMEASentence {
    private int dateTimeOfFix = -1;
    private String warning = "";
    private double latitude = 0.0;
    private String latitudeDirection = "";
    private double longitude = 0.0;
    private String longitudeDirection = "";
    private float groundSpeed;
    private String courseMadeGood = null;
    private int dateOfFix = -1;
    private String magneticVariation = null;
    private float speed;
    public static final String HEADER = "$GPRMC";

    public String getHeader() {
        return HEADER;
    }

    public double getLatitudeRAW() {
        this.checkRefresh();
        return this.latitude;
    }

    public double getLongitudeRAW() {
        this.checkRefresh();
        return this.longitude;
    }

    public float getSpeed() {
        this.checkRefresh();
        return this.speed;
    }

    public int getDate() {
        this.checkRefresh();
        return this.dateOfFix;
    }

    public float getCompassDegrees() {
        this.checkRefresh();
        float compassDegrees = -1.0f;
        if (this.courseMadeGood != null) {
            compassDegrees = Float.parseFloat(this.courseMadeGood);
        }
        return compassDegrees;
    }

    public String getMagneticVariation() {
        return this.magneticVariation;
    }

    protected void parse(String sentence) {
        this.st = new StringTokenizer(sentence, ",");
        try {
            this.st.nextToken();
            this.dateTimeOfFix = (int)Float.parseFloat(this.st.nextToken());
            this.warning = this.st.nextToken();
            this.latitude = this.degreesMinToDegrees(this.st.nextToken());
            this.latitudeDirection = this.st.nextToken();
            this.longitude = this.degreesMinToDegrees(this.st.nextToken());
            this.longitudeDirection = this.st.nextToken();
            String s = this.st.nextToken();
            this.groundSpeed = s.equals("") ? 0.0f : Float.parseFloat(s);
            this.courseMadeGood = this.st.nextToken();
            this.dateOfFix = Integer.parseInt(this.st.nextToken());
            this.magneticVariation = this.st.nextToken();
        }
        catch (NoSuchElementException e) {
            System.err.println("Threw a NoSuch exception");
        }
        catch (NumberFormatException e) {
            System.err.println("Threw a NumFormat exception");
        }
        if (!this.longitudeDirection.equals("E")) {
            this.longitude = -this.longitude;
        }
        if (!this.latitudeDirection.equals("N")) {
            this.latitude = -this.latitude;
        }
        if (this.groundSpeed > 0.0f) {
            this.speed = (float)((double)this.groundSpeed * 1.852);
        }
        if (this.speed < 0.0f) {
            this.speed = 0.0f;
        }
    }
}

