/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCollection<E>
implements Collection<E> {
    AbstractCollection() {
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean r = false;
        for (E element : c) {
            r |= this.add(element);
        }
        return r;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean r = false;
        for (Object o : c) {
            r |= this.remove(o);
        }
        return r;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean r = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (c.contains(element)) continue;
            r = true;
            i.remove();
        }
        return r;
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        return this.toArray(new Object[size]);
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        int j = 0;
        int max = dest.length;
        for (Object element : this) {
            if (j >= max) {
                throw new UnsupportedOperationException("Array is too small and expanding is not supported.");
            }
            dest[j++] = element;
        }
        return dest;
    }
}

