/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NXTSocketOutputStream;
import lejos.nxt.comm.NXTConnection;

public class Socket {
    private DataOutputStream outToProxy;
    private DataInputStream inFromProxy;
    private NXTConnection nxtc;
    private String host;
    private int port;
    private boolean isServer = false;
    private NXTSocketOutputStream os;
    private static final int BUFFER_SIZE = 64;

    public Socket(String host, int port, NXTConnection nxtc) throws IOException {
        this.host = host;
        this.port = port;
        this.nxtc = nxtc;
        this.inFromProxy = new DataInputStream(nxtc.openInputStream());
        this.outToProxy = new DataOutputStream(nxtc.openOutputStream());
        this.negotiateConnection();
        this.outToProxy.close();
        this.inFromProxy.close();
    }

    public Socket(NXTConnection nxtc) {
        this.nxtc = nxtc;
    }

    private void negotiateConnection() throws IOException {
        if (this.host.length() == 0) {
            throw new IOException();
        }
        this.outToProxy = new DataOutputStream(this.nxtc.openOutputStream());
        this.outToProxy.writeBoolean(this.isServer);
        this.outToProxy.writeByte(this.host.length());
        this.outToProxy.writeChars(this.host);
        this.outToProxy.writeInt(this.port);
        this.outToProxy.flush();
        if (!this.inFromProxy.readBoolean()) {
            throw new IOException();
        }
    }

    public DataInputStream getDataInputStream() throws IOException {
        return new DataInputStream(this.getInputStream());
    }

    public DataOutputStream getDataOutputStream() throws IOException {
        return new DataOutputStream(this.getOutputStream());
    }

    public OutputStream getOutputStream() throws IOException {
        this.os = new NXTSocketOutputStream(this.nxtc, 64);
        return this.os;
    }

    public InputStream getInputStream() throws IOException {
        return this.nxtc.openInputStream();
    }

    public void close() {
        try {
            this.os.writeClose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

