/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private Thread _TVM_nextThread;
    private Object _TVM_waitingOn;
    private int _TVM_sync;
    private int _TVM_sleepUntil;
    private Object _TVM_stackFrameArray;
    private Object _TVM_stackArray;
    private byte _TVM_stackFrameArraySize;
    private byte _TVM_monitorCount;
    private byte _TVM_threadId;
    private byte _TVM_state;
    private byte _TVM_priority;
    private byte _TVM_interrupted;
    private byte _TVM_daemon;
    private String name;

    public final boolean isAlive() {
        return this._TVM_state > 1;
    }

    private void init(String name, Runnable target) {
        Thread t = Thread.currentThread();
        if (t == null) {
            this.setPriority(5);
        } else {
            this.setPriority(t.getPriority());
            this.setDaemon(t.isDaemon());
        }
        this.name = name;
        this._TVM_waitingOn = target;
    }

    public Thread() {
        this.init("", null);
    }

    public Thread(String name) {
        this.init(name, null);
    }

    public Thread(Runnable target) {
        this.init("", target);
    }

    public Thread(String name, Runnable target) {
        this.init(name, target);
    }

    public void run() {
        if (this._TVM_waitingOn != null) {
            ((Runnable)this._TVM_waitingOn).run();
        }
    }

    public void start() {
        this.init_thread();
    }

    public final native void init_thread();

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    public static native Thread currentThread();

    public final native int getPriority();

    public int getId() {
        return this._TVM_threadId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPriority(int priority) {
        if (1 > priority || 10 < priority) {
            throw new IllegalArgumentException("priority must be between 1 and 10");
        }
        this.set_priority(priority);
    }

    public final native void set_priority(int var1);

    public native void interrupt();

    public static native boolean interrupted();

    public final native boolean isInterrupted();

    public final native boolean isDaemon();

    public final native void setDaemon(boolean var1);

    public final native void join() throws InterruptedException;

    public final native void join(long var1) throws InterruptedException;
}

