/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    private static final int DEFAULT_BUFFERSIZE = 64;
    private static final int MIN_BUFFERSIZE = 1;
    private final byte[] buffer;
    private int limit;

    public BufferedOutputStream(OutputStream out) {
        this(out, 64);
    }

    public BufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size < 1) {
            size = 1;
        }
        this.buffer = new byte[size];
    }

    public void close() throws IOException {
        try {
            this.flushAny();
        }
        finally {
            this.out.close();
        }
    }

    private void flushAny() throws IOException {
        if (this.limit > 0) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
    }

    private int flushFull() throws IOException {
        if (this.limit >= this.buffer.length) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        return this.buffer.length - this.limit;
    }

    public void flush() throws IOException {
        this.flushAny();
        this.out.flush();
    }

    public void write(int c) throws IOException {
        this.flushFull();
        this.buffer[this.limit++] = (byte)c;
    }

    public void write(byte[] c, int off, int len) throws IOException {
        while (len > 0) {
            int plen = this.flushFull();
            if (plen > len) {
                plen = len;
            }
            System.arraycopy(c, off, this.buffer, this.limit, plen);
            len -= plen;
            off += plen;
            this.limit += plen;
        }
    }
}

