/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.IOException;
import java.io.InputStream;
import lejos.pc.comm.FlashWrite;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommFactory;
import lejos.pc.comm.NXTCommUSB;
import lejos.pc.comm.NXTInfo;

public class NXTSamba {
    private static final String CHARSET = "iso-8859-1";
    private static final char CMD_GOTO = 'G';
    private static final char CMD_TEXT = 'T';
    private static final char CMD_NON_TEXT = 'N';
    private static final char CMD_VERSION = 'V';
    private static final char CMD_READ_OCTET = 'o';
    private static final char CMD_READ_HWORD = 'h';
    private static final char CMD_READ_WORD = 'w';
    private static final char CMD_READ_STREAM = 'R';
    private static final char CMD_WRITE_OCTET = 'O';
    private static final char CMD_WRITE_HWORD = 'H';
    private static final char CMD_WRITE_WORD = 'W';
    private static final char CMD_WRITE_STREAM = 'S';
    private static final byte PROMPT_CHAR = 62;
    private static final int RAM_BASE = 0x200000;
    private static final int RAM_MAX = 0x210000;
    public static final int FLASH_BASE = 0x100000;
    public static final int FLASH_MAX = 0x140000;
    public static final int PAGE_SIZE = 256;
    private static final int SAMBA_RAM_BASE = 0x202000;
    private static final int SAMBA_RAM_MAX = 0x210000;
    private static final int HELPER_STACKSIZE = 4096;
    private static final int HELPER_CODEADR = 0x203000;
    private static final int HELPER_DATAADR = 0x203000 + FlashWrite.CODE.length;
    private static final int HELPER_PACKET = 260;
    private NXTCommUSB nxtComm = null;
    private String version;

    public NXTInfo[] search() throws NXTCommException {
        NXTInfo[] nxtInfos;
        if (this.nxtComm == null) {
            try {
                this.nxtComm = (NXTCommUSB)NXTCommFactory.createNXTComm(1);
            }
            catch (NXTCommException nXTCommException) {
                // empty catch block
            }
            if (this.nxtComm == null) {
                throw new NXTCommException("Cannot load a comm driver");
            }
        }
        if ((nxtInfos = this.nxtComm.search("%%NXT-SAMBA%%", 1)).length > 0) {
            return nxtInfos;
        }
        return new NXTInfo[0];
    }

    private byte[] read() throws IOException {
        byte[] ret = this.nxtComm.read(false);
        if (ret == null || ret.length == 0) {
            throw new IOException("Read timeout");
        }
        return ret;
    }

    private int readAnswerWord(int len) throws IOException {
        byte[] ret = this.read();
        if (ret.length != len) {
            throw new IOException("bad packet length");
        }
        int r = 0;
        int i = len;
        while (i > 0) {
            r <<= 8;
            r |= ret[--i] & 0xFF;
        }
        return r;
    }

    private void readAnswerStream(byte[] data, int off, int len) throws IOException {
        while (len > 0) {
            byte[] ret = this.read();
            int rlen = ret.length;
            if (rlen > len) {
                throw new IOException("bad packet length");
            }
            System.arraycopy(ret, 0, data, off, rlen);
            off += rlen;
            len -= rlen;
        }
    }

    private static boolean endsWithLinefeed(byte[] ret) {
        int len = ret.length;
        return len >= 2 && (ret[len - 2] == 10 || ret[len - 1] == 13);
    }

    private static boolean endsWithPrompt(byte[] ret) {
        int len = ret.length;
        return len >= 1 && ret[len - 1] == 62;
    }

    private String readLine() throws IOException {
        byte[] ret;
        StringBuilder sb = new StringBuilder();
        do {
            ret = this.read();
            sb.append(new String(ret, CHARSET));
        } while (!NXTSamba.endsWithLinefeed(ret));
        return sb.toString();
    }

    private void write(byte[] data) throws IOException {
        if (this.nxtComm.write(data, true) != data.length) {
            throw new IOException("Write timeout");
        }
    }

    private void writeString(String str) throws IOException {
        this.write(str.getBytes(CHARSET));
    }

    private void sendInitCommand(char cmd) throws IOException {
        String command = cmd + "#";
        this.writeString(command);
    }

    private void sendGotoCommand(int addr) throws IOException {
        String command = 'G' + NXTSamba.hexFormat(addr, 8) + "#";
        this.writeString(command);
    }

    private void sendStreamCommand(char cmd, int addr, int len) throws IOException {
        String command = cmd + NXTSamba.hexFormat(addr, 8) + "," + NXTSamba.hexFormat(len, 8) + "#";
        this.writeString(command);
    }

    private void sendWriteCommand(char cmd, int addr, int len, int value) throws IOException {
        String command = cmd + NXTSamba.hexFormat(addr, 8) + "," + NXTSamba.hexFormat(value, 2 * len) + "#";
        this.writeString(command);
    }

    private void sendReadCommand(char cmd, int addr, int len) throws IOException {
        String command = cmd + NXTSamba.hexFormat(addr, 8) + "," + len + "#";
        this.writeString(command);
    }

    private static String hexFormat(int value, int len) {
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            int shift = 4 * (len - i - 1);
            int c = value >>> shift & 0xF;
            c = c < 10 ? (c += 48) : (c += 55);
            buf[i] = (char)c;
        }
        return String.valueOf(buf);
    }

    public void writeOctet(int addr, int val) throws IOException {
        this.sendWriteCommand('O', addr, 1, val);
    }

    public void writeHalfword(int addr, int val) throws IOException {
        this.sendWriteCommand('H', addr, 2, val);
    }

    public void writeWord(int addr, int val) throws IOException {
        this.sendWriteCommand('W', addr, 4, val);
    }

    public int readOctet(int addr) throws IOException {
        this.sendReadCommand('o', addr, 1);
        return this.readAnswerWord(1);
    }

    public int readHalfword(int addr) throws IOException {
        this.sendReadCommand('h', addr, 2);
        return this.readAnswerWord(2);
    }

    public int readWord(int addr) throws IOException {
        this.sendReadCommand('w', addr, 4);
        return this.readAnswerWord(4);
    }

    public InputStream createInputStream(int addr, int len) throws IOException {
        this.sendStreamCommand('R', addr, len);
        return new MemoryInputStream(len);
    }

    public void readBytes(int addr, byte[] data, int off, int len) throws IOException {
        this.sendStreamCommand('R', addr, len);
        this.readAnswerStream(data, off, len);
    }

    public void writeBytes(int addr, byte[] data) throws IOException {
        this.sendStreamCommand('S', addr, data.length);
        this.write(data);
    }

    public void jump(int addr) throws IOException {
        this.sendGotoCommand(addr);
    }

    public void reboot() throws IOException {
        this.sendGotoCommand(0x100000);
    }

    private void waitReady() throws IOException {
        while ((this.readWord(-152) & 1) == 0) {
            Thread.yield();
        }
    }

    private void changeLock(int rgn, boolean lock) throws IOException {
        int cmd = 0x5A000000 | 64 * rgn << 8;
        cmd = lock ? (cmd |= 2) : (cmd |= 4);
        this.waitReady();
        this.writeWord(-160, 327936);
        this.writeWord(-156, cmd);
        this.writeWord(-160, 3408128);
    }

    public void unlockAllPages() throws IOException {
        for (int i = 0; i < 16; ++i) {
            this.changeLock(i, false);
        }
    }

    public void writePage(int page, byte[] data, int offset) throws IOException {
        this.writePage(page, data, offset, data.length - offset);
    }

    public void writePage(int page, byte[] data, int offset, int len) throws IOException {
        if (len > 256) {
            len = 256;
        }
        byte[] buf = new byte[260];
        System.arraycopy(data, offset, buf, 4, len);
        NXTSamba.encodeInt(buf, 0, page);
        this.writeBytes(HELPER_DATAADR, buf);
        this.sendGotoCommand(0x203000);
    }

    public void writePages(int first, byte[] data, int start, int len) throws IOException {
        while (len > 0) {
            this.writePage(first, data, start, len);
            start += 256;
            len -= 256;
            ++first;
        }
    }

    public void readPage(int page, byte[] data, int offset) throws IOException {
        int addr = 0x100000 + page * 256;
        this.readBytes(addr, data, offset, 256);
    }

    public void readPages(int first, byte[] data, int start, int len) throws IOException {
        int page = first;
        for (int offset = start; offset < start + len; offset += 256) {
            this.readPage(page, data, offset);
            ++page;
        }
    }

    public boolean open(NXTInfo nxt) throws IOException {
        if (this.nxtComm.open(nxt, 2)) {
            try {
                this.sendInitCommand('T');
                while (!NXTSamba.endsWithPrompt(this.read())) {
                }
                this.sendInitCommand('N');
                this.readLine();
                this.sendInitCommand('V');
                this.version = this.readLine().trim();
                this.version = this.version.replaceAll("\\s.*", "");
                System.out.println("Connected to SAM-BA " + this.version);
                this.writeBytes(0x203000, NXTSamba.getModifiedHelper());
                this.writeWord(-976, 7);
                return true;
            }
            catch (IOException iOException) {
                this.nxtComm.close();
            }
        }
        return false;
    }

    private static byte[] getModifiedHelper() {
        byte[] code = FlashWrite.CODE;
        int len = code.length;
        byte[] r = new byte[len];
        System.arraycopy(code, 0, r, 0, len);
        return r;
    }

    private static void encodeInt(byte[] code, int off, int value) {
        for (int i = 0; i < 4; ++i) {
            code[off + i] = (byte)value;
            value >>>= 8;
        }
    }

    public void close() {
        this.nxtComm.close();
    }

    public String getVersion() throws IOException {
        return this.version;
    }

    static {
        assert (HELPER_DATAADR + 260 <= 0x210000);
    }

    private class MemoryInputStream
    extends InputStream {
        private int len;
        private byte[] buf;
        private int off;

        public MemoryInputStream(int len) {
            this.len = len;
        }

        private boolean fillBuffer() throws IOException {
            if (this.buf == null || this.off >= this.buf.length) {
                if (this.len <= 0) {
                    return false;
                }
                this.buf = NXTSamba.this.read();
                this.off = 0;
                if (this.buf.length > this.len) {
                    throw new IOException("protocol error");
                }
                this.len -= this.buf.length;
            }
            return true;
        }

        public int read() throws IOException {
            if (!this.fillBuffer()) {
                return -1;
            }
            return this.buf[this.off++] & 0xFF;
        }

        public void close() throws IOException {
            while (this.fillBuffer()) {
                this.buf = null;
            }
        }
    }
}

