/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.util.Vector;
import lejos.pc.comm.NXTCommUSB;
import lejos.pc.comm.NXTInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NXTCommFantom
extends NXTCommUSB {
    private static final int MIN_TIMEOUT = 5000;
    private static final int MAX_ERRORS = 10;

    public native String[] jfantom_find();

    public native long jfantom_open(String var1);

    public native void jfantom_close(long var1);

    public native int jfantom_send_data(long var1, byte[] var3, int var4, int var5);

    public native int jfantom_read_data(long var1, byte[] var3, int var4, int var5);

    @Override
    Vector<NXTInfo> devFind() {
        return this.find(this.jfantom_find());
    }

    @Override
    long devOpen(NXTInfo nxt) {
        if (nxt.btResourceString == null) {
            return 0L;
        }
        return this.jfantom_open(nxt.btResourceString);
    }

    @Override
    void devClose(long nxt) {
        this.jfantom_close(nxt);
    }

    @Override
    int devWrite(long nxt, byte[] message, int offset, int len) {
        return this.jfantom_send_data(nxt, message, offset, len);
    }

    @Override
    int devRead(long nxt, byte[] data, int offset, int len) {
        int ret;
        long startTime = System.currentTimeMillis();
        int errorCnt = 0;
        while ((ret = this.jfantom_read_data(nxt, data, offset, len)) == 0) {
            long now = System.currentTimeMillis();
            if (now - startTime > 5000L) {
                return ret;
            }
            if (errorCnt++ > 10) {
                return -1;
            }
            startTime = now;
        }
        return ret;
    }

    @Override
    boolean devIsValid(NXTInfo nxt) {
        return nxt.btResourceString != null;
    }

    static {
        try {
            System.loadLibrary("jfantom");
        }
        catch (Exception e) {
            System.out.println("Caught exception " + e + "while trying to load driver");
            throw (RuntimeException)e;
        }
    }
}

