/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommInputStream;
import lejos.pc.comm.NXTCommOutputStream;
import lejos.pc.comm.NXTConnectionState;
import lejos.pc.comm.NXTInfo;

public class NXTCommBluecove
implements NXTComm,
DiscoveryListener {
    private static Vector<RemoteDevice> devices;
    private static Vector<NXTInfo> nxtInfos;
    private StreamConnection con;
    private OutputStream os;
    private InputStream is;
    private NXTInfo nxtInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXTInfo[] search(String name, int protocol) throws NXTCommException {
        devices = new Vector();
        nxtInfos = new Vector();
        if ((protocol & 2) == 0) {
            return new NXTInfo[0];
        }
        NXTCommBluecove nXTCommBluecove = this;
        synchronized (nXTCommBluecove) {
            try {
                LocalDevice.getLocalDevice().getDiscoveryAgent().startInquiry(10390323, (DiscoveryListener)this);
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    System.err.println(e.getMessage());
                }
            }
            catch (Throwable t) {
                throw new NXTCommException("Bluetooth stack not detected", t);
            }
        }
        Enumeration<RemoteDevice> enum_d = devices.elements();
        while (enum_d.hasMoreElements()) {
            RemoteDevice d = enum_d.nextElement();
            try {
                this.nxtInfo = new NXTInfo();
                this.nxtInfo.name = d.getFriendlyName(false);
                if (this.nxtInfo.name == null || this.nxtInfo.name.length() == 0) {
                    this.nxtInfo.name = "Unknown";
                }
                this.nxtInfo.deviceAddress = d.getBluetoothAddress();
                this.nxtInfo.protocol = 2;
                if (name != null && !name.equals(this.nxtInfo.name)) continue;
                nxtInfos.addElement(this.nxtInfo);
                System.out.println("Found: " + this.nxtInfo.name);
                int[] attributes = new int[]{256, 257, 258};
                UUID[] uuids = new UUID[]{new UUID("1101", true)};
                NXTCommBluecove nXTCommBluecove2 = this;
                synchronized (nXTCommBluecove2) {
                    try {
                        LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(attributes, uuids, d, (DiscoveryListener)this);
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            System.err.println(e.getMessage());
                        }
                    }
                    catch (BluetoothStateException e) {
                        System.err.println(e.getMessage());
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    System.err.println(e.getMessage());
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        NXTInfo[] nxts = new NXTInfo[nxtInfos.size()];
        for (int i = 0; i < nxts.length; ++i) {
            nxts[i] = nxtInfos.elementAt(i);
        }
        return nxts;
    }

    public boolean open(NXTInfo nxt, int mode) throws NXTCommException {
        if (mode == 2) {
            throw new NXTCommException("RAW mode not implemented");
        }
        if (nxt.btResourceString == null || nxt.btResourceString.length() < 5 || !nxt.btResourceString.substring(0, 5).equals("btspp")) {
            nxt.btResourceString = "btspp://" + this.stripColons(nxt.deviceAddress) + ":1;authenticate=false;encrypt=false";
        }
        try {
            this.con = (StreamConnection)Connector.open((String)nxt.btResourceString);
            this.os = this.con.openOutputStream();
            this.is = this.con.openInputStream();
            nxt.connectionState = mode == 1 ? NXTConnectionState.LCP_CONNECTED : NXTConnectionState.PACKET_STREAM_CONNECTED;
            return true;
        }
        catch (IOException e) {
            nxt.connectionState = NXTConnectionState.DISCONNECTED;
            throw new NXTCommException("Open of " + nxt.name + " failed: " + e.getMessage());
        }
    }

    public boolean open(NXTInfo nxt) throws NXTCommException {
        return this.open(nxt, 0);
    }

    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
        if (this.is != null) {
            this.is.close();
        }
        if (this.con != null) {
            this.con.close();
        }
    }

    public synchronized byte[] sendRequest(byte[] message, int replyLen) throws IOException {
        int LSB = message.length;
        int MSB = message.length >>> 8;
        if (this.os == null) {
            return new byte[0];
        }
        this.os.write((byte)LSB);
        this.os.write((byte)MSB);
        this.os.write(message);
        this.os.flush();
        if (replyLen == 0) {
            return new byte[0];
        }
        byte[] reply = null;
        int length = -1;
        if (this.is == null) {
            return new byte[0];
        }
        while ((length = this.is.read()) < 0) {
        }
        int lengthMSB = this.is.read();
        reply = new byte[length = 0xFF & length | (0xFF & lengthMSB) << 8];
        int len = this.is.read(reply);
        if (len != replyLen) {
            throw new IOException("Unexpected reply length");
        }
        return reply == null ? new byte[]{} : reply;
    }

    public byte[] read() throws IOException {
        int lsb = this.is.read();
        if (lsb < 0) {
            return null;
        }
        int msb = this.is.read();
        if (msb < 0) {
            return null;
        }
        int len = lsb | msb << 8;
        byte[] bb = new byte[len];
        for (int i = 0; i < len; ++i) {
            bb[i] = (byte)this.is.read();
        }
        return bb;
    }

    public int available() throws IOException {
        return 0;
    }

    public void write(byte[] data) throws IOException {
        this.os.write((byte)(data.length & 0xFF));
        this.os.write((byte)(data.length >> 8 & 0xFF));
        this.os.write(data);
        this.os.flush();
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (cod.getMajorDeviceClass() == 2048 && cod.getMinorDeviceClass() == 4) {
            devices.addElement(btDevice);
        }
    }

    public synchronized void inquiryCompleted(int discType) {
        this.notifyAll();
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        if (servRecord.length != 1) {
            return;
        }
        this.nxtInfo.btResourceString = servRecord[0].getConnectionURL(0, false);
    }

    public synchronized void serviceSearchCompleted(int transID, int respCode) {
        this.notifyAll();
    }

    public OutputStream getOutputStream() {
        return new NXTCommOutputStream(this);
    }

    public InputStream getInputStream() {
        return new NXTCommInputStream(this);
    }

    public String stripColons(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ':') continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

