/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.io.IOException;
import javax.swing.JButton;
import lejos.geom.Line;
import lejos.pc.comm.RemoteFrame;
import lejos.robotics.Pose;
import lejos.robotics.RangeReadings;
import lejos.robotics.localization.MCLParticle;
import lejos.robotics.localization.MCLParticleSet;
import lejos.robotics.mapping.LineMap;

public class MCLFrame
extends RemoteFrame {
    private static final long serialVersionUID = 1L;
    public static final float PIXELS_PER_CM = 2.0f;
    public static final float X_OFFSET = 66.0f;
    public static final float Y_OFFSET = 56.0f;
    private static final float ARROW_LENGTH = 10.0f;
    private static final byte GET_PARTICLES = 0;
    private static final byte READINGS = 1;
    private static final byte RANDOM_MOVE = 2;
    private static final byte STOP = 3;
    private static final byte FIND_CLOSEST = 4;
    private static final int MAX_CLUSTER_SIZE = 25;
    private Line[] lines;
    private LineMap map;
    private MCLParticleSet particles;
    private RangeReadings readings;
    private int closest = -1;
    private int numParticles;
    private JButton readingsButton;
    private JButton moveButton;
    private JButton stopButton;

    public void paintComponent(Graphics g) {
        this.clear(g);
        Graphics2D g2d = (Graphics2D)g;
        this.paintMap(g2d);
        this.paintParticles(g2d);
        this.paintLocation(g2d);
    }

    private void paintParticles(Graphics2D g2d) {
        g2d.setColor(Color.red);
        for (int i = 0; i < this.numParticles; ++i) {
            MCLParticle part = this.particles.getParticle(i);
            if (part == null) continue;
            if (i == this.closest) {
                g2d.setColor(Color.green);
            }
            this.paintPose(g2d, new Pose(part.getPose().getX(), part.getPose().getY(), part.getPose().getHeading()));
            g2d.setColor(Color.red);
        }
    }

    private void paintMap(Graphics2D g2d) {
        g2d.setColor(Color.black);
        for (int i = 0; i < this.lines.length; ++i) {
            Line2D.Float line = new Line2D.Float(66.0f + this.lines[i].x1 * 2.0f, 56.0f + this.lines[i].y1 * 2.0f, 66.0f + this.lines[i].x2 * 2.0f, 56.0f + this.lines[i].y2 * 2.0f);
            g2d.draw(line);
        }
    }

    private void paintPose(Graphics2D g2d, Pose pose) {
        Ellipse2D.Float c = new Ellipse2D.Float(66.0f + pose.getX() * 2.0f - 1.0f, 56.0f + pose.getY() * 2.0f - 1.0f, 2.0f, 2.0f);
        Line rl = this.getArrowLine(pose);
        Line2D.Float l2d = new Line2D.Float(rl.x1, rl.y1, rl.x2, rl.y2);
        g2d.draw(l2d);
        g2d.draw(c);
    }

    private void paintLocation(Graphics2D g2d) {
        float minX = this.particles.getMinX();
        float maxX = this.particles.getMaxX();
        float minY = this.particles.getMinY();
        float maxY = this.particles.getMaxY();
        Pose estimatedPose = this.particles.getEstimatedPose();
        if (maxX - minX > 0.0f && maxX - minX <= 25.0f && maxY - minY > 0.0f && maxY - minY <= 25.0f) {
            Ellipse2D.Float c = new Ellipse2D.Float(66.0f + minX * 2.0f, 56.0f + minY * 2.0f, (maxX - minX) * 2.0f, (maxY - minY) * 2.0f);
            g2d.setColor(Color.blue);
            g2d.draw(c);
            this.paintPose(g2d, estimatedPose);
        }
    }

    private Line getArrowLine(Pose pose) {
        return new Line(66.0f + pose.getX() * 2.0f, 56.0f + pose.getY() * 2.0f, 66.0f + pose.getX() * 2.0f + 10.0f * (float)Math.cos(Math.toRadians(pose.getHeading())), 56.0f + pose.getY() * 2.0f + 10.0f * (float)Math.sin(Math.toRadians(pose.getHeading())));
    }

    public MCLFrame(String nxt, Line[] lines, Rectangle bound, int numParticles, int numReadings) throws IOException {
        super(nxt);
        this.lines = lines;
        this.map = new LineMap(lines, bound);
        this.numParticles = numParticles;
        this.particles = new MCLParticleSet(this.map, numParticles, 10);
        this.readingsButton = this.createButton("Readings");
        this.moveButton = this.createButton("Move");
        this.stopButton = this.createButton("Stop");
        this.map.dumpMap(this.dos);
        this.dos.writeInt(numParticles);
        this.dos.flush();
        this.getParticles();
        this.readings = new RangeReadings(numReadings);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.readingsButton) {
                this.sendCommand((byte)1);
                this.readings.loadReadings(this.dis);
                this.readings.printReadings();
                System.out.println("Max weight = " + this.dis.readFloat());
                this.getParticles();
                this.repaint();
            }
            if (e.getSource() == this.moveButton) {
                this.sendCommand((byte)2);
                this.getParticles();
                this.repaint();
            }
            if (e.getSource() == this.stopButton) {
                this.close();
            }
        }
        catch (IOException ioe) {
            this.error("IOException");
        }
    }

    private int findClosest(int x, int y) {
        this.sendCommand((byte)4);
        try {
            this.dos.writeFloat(x);
            this.dos.writeFloat(y);
            this.dos.flush();
            int closest = this.dis.readInt();
            for (int i = 0; i < 3; ++i) {
                float reading = this.dis.readFloat();
                System.out.println("Reading " + i + " = " + (reading < 0.0f ? "Invalid" : Float.valueOf(reading)));
            }
            System.out.println("Weight = " + this.dis.readFloat());
            return closest;
        }
        catch (IOException ioe) {
            this.error("IOException");
            return -1;
        }
    }

    private void getParticles() throws IOException {
        this.sendCommand((byte)0);
        this.particles.loadParticles(this.dis);
        this.particles.loadEstimation(this.dis);
    }

    private void sendCommand(byte command) {
        try {
            this.dos.writeByte(command);
            this.dos.flush();
        }
        catch (IOException ioe) {
            this.error("IO Exception");
        }
    }

    private void close() {
        try {
            this.dos.writeByte(3);
            this.dos.flush();
            Thread.sleep(1000L);
            System.exit(0);
        }
        catch (Exception ioe) {
            this.error("IO Exception");
        }
    }

    public void mouseClicked(MouseEvent me) {
        int x = (int)(((float)me.getX() - 66.0f) / 2.0f);
        int y = (int)(((float)me.getY() - 56.0f) / 2.0f);
        System.out.println("X = " + x + ", Y = " + y);
        this.closest = this.findClosest(x, y);
        this.repaint();
    }
}

