/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import java.io.IOException;
import lejos.nxt.remote.DeviceInfo;
import lejos.nxt.remote.FirmwareInfo;
import lejos.nxt.remote.NXTCommand;
import lejos.pc.comm.NXTCommandConnector;

public class NXT {
    private static NXTCommand nxtCommand = NXTCommandConnector.getSingletonOpen();

    public static float getFirmwareVersion() {
        try {
            FirmwareInfo f = nxtCommand.getFirmwareVersion();
            return Float.parseFloat(f.firmwareVersion);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return 0.0f;
        }
    }

    public static float getProtocolVersion() {
        try {
            FirmwareInfo f = nxtCommand.getFirmwareVersion();
            return Float.parseFloat(f.protocolVersion);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return 0.0f;
        }
    }

    public static int getFlashMemory() {
        try {
            DeviceInfo i = nxtCommand.getDeviceInfo();
            return i.freeFlash;
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return 0;
        }
    }

    public static byte deleteFlashMemory() {
        try {
            return nxtCommand.deleteUserFlash();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
    }

    public static String getBrickName() {
        try {
            DeviceInfo i = nxtCommand.getDeviceInfo();
            return i.NXTname;
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return null;
        }
    }

    public static byte setBrickName(String newName) {
        try {
            return nxtCommand.setFriendlyName(newName);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
    }

    public static int getSignalStrength() {
        try {
            DeviceInfo i = nxtCommand.getDeviceInfo();
            return i.signalStrength;
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
    }

    public static void exit(int code) {
        try {
            NXTCommand.getSingleton().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(code);
    }
}

