/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import java.io.IOException;
import lejos.nxt.I2CPort;
import lejos.nxt.SensorConstants;
import lejos.nxt.remote.NXTCommand;
import lejos.pc.comm.NXTCommandConnector;

public class I2CSensor
implements SensorConstants {
    private static final NXTCommand nxtCommand = NXTCommandConnector.getSingletonOpen();
    protected byte address = (byte)2;
    protected static byte STOP = 0;
    protected static String BLANK = "       ";
    protected static byte VERSION = 0;
    protected static byte PRODUCT_ID = (byte)8;
    protected static byte SENSOR_TYPE = (byte)16;
    byte port;

    public I2CSensor(I2CPort s, byte sensorType) {
        this.port = (byte)s.getId();
        s.setTypeAndMode(sensorType, 0);
        try {
            nxtCommand.LSGetStatus(this.port);
            nxtCommand.LSRead(this.port);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public I2CSensor(I2CPort s) {
        this(s, 10);
    }

    public int getId() {
        return this.port;
    }

    public int getData(int register, byte[] buf, int length) {
        byte[] txData = new byte[]{this.address, (byte)register};
        try {
            nxtCommand.LSWrite(this.port, txData, (byte)length);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        byte[] status = null;
        do {
            try {
                status = nxtCommand.LSGetStatus(this.port);
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                return -1;
            }
        } while (status[0] == 32 | status[0] == -32);
        try {
            byte[] ret = nxtCommand.LSRead(this.port);
            if (ret != null) {
                System.arraycopy(ret, 0, buf, 0, ret.length);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
        return status[0];
    }

    public int getData(int register) {
        byte[] buf1 = new byte[1];
        return this.getData(register, buf1, 1);
    }

    public int sendData(int register, byte value) {
        byte[] txData = new byte[]{this.address, (byte)register, value};
        try {
            byte ret = nxtCommand.LSWrite(this.port, txData, (byte)0);
            return ret;
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
    }

    public int sendData(int register, byte[] data, int length) {
        byte[] txData = new byte[]{this.address, (byte)register};
        byte[] sendData = new byte[length + 2];
        System.arraycopy(txData, 0, sendData, 0, 2);
        System.arraycopy(data, 0, sendData, 2, length);
        try {
            return nxtCommand.LSWrite(this.port, sendData, (byte)0);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
    }

    public String getVersion() {
        return this.fetchString(VERSION, 8);
    }

    public String getProductID() {
        return this.fetchString(PRODUCT_ID, 8);
    }

    public String getSensorType() {
        return this.fetchString(SENSOR_TYPE, 8);
    }

    protected String fetchString(int constantEnumeration, int rxLength) {
        byte[] stringBytes = new byte[rxLength];
        this.getData(constantEnumeration, stringBytes, rxLength);
        int zeroPos = 0;
        for (zeroPos = 0; zeroPos < rxLength && stringBytes[zeroPos] != 0; ++zeroPos) {
        }
        String s = new String(stringBytes).substring(0, zeroPos);
        return s;
    }

    public void setAddress(int addr) {
        this.address = (byte)(addr << 1);
    }
}

