/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import lejos.nxt.remote.FileInfo;
import lejos.nxt.remote.NXTCommand;
import lejos.pc.comm.NXTCommandConnector;

public class FileSystem {
    private static final NXTCommand nxtCommand = NXTCommandConnector.getSingletonOpen();

    private FileSystem() {
    }

    public static byte upload(File localSource) {
        byte success;
        byte[] data;
        try {
            FileInputStream in = new FileInputStream(localSource);
            data = new byte[(int)localSource.length()];
            in.read(data);
            in.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
        try {
            byte handle = nxtCommand.openWrite(localSource.getName(), data.length);
            success = nxtCommand.writeFile(handle, data);
            nxtCommand.closeFile(handle);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
        return success;
    }

    public static byte[] download(String fileName) {
        byte[] data;
        try {
            FileInfo finfo = nxtCommand.openRead(fileName);
            if (finfo.status != 0) {
                byte[] data2 = new byte[]{finfo.status};
                return data2;
            }
            data = nxtCommand.readFile(finfo.fileHandle, finfo.fileSize);
            nxtCommand.closeFile(finfo.fileHandle);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return null;
        }
        return data;
    }

    public static byte download(String fileName, File destination) {
        byte[] data = FileSystem.download(fileName);
        File fullFile = destination.isDirectory() ? new File(destination.toString() + File.separator + fileName) : destination;
        try {
            if (fullFile.createNewFile()) {
                FileOutputStream out = new FileOutputStream(fullFile);
                out.write(data);
                out.close();
            }
        }
        catch (IOException e) {
            System.out.println("File write failed");
            return -1;
        }
        return 0;
    }

    public static byte download(String fileName, String destination) {
        File file = new File(destination);
        return FileSystem.download(fileName, file);
    }

    public static byte delete(String fileName) {
        try {
            return nxtCommand.delete(fileName);
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public static String[] getFileNames() {
        return FileSystem.getFileNames("*.*");
    }

    public static String[] getFileNames(String searchCriteria) {
        try {
            ArrayList<String> names = new ArrayList<String>(1);
            FileInfo f = nxtCommand.findFirst(searchCriteria);
            if (f == null) {
                return null;
            }
            do {
                names.add(f.fileName);
                if (f == null) continue;
                nxtCommand.closeFile(f.fileHandle);
            } while ((f = nxtCommand.findNext(f.fileHandle)) != null);
            String[] returnArray = new String[1];
            return names.toArray(returnArray);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return null;
        }
    }

    public static String getCurrentProgramName() {
        try {
            return nxtCommand.getCurrentProgramName();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return null;
        }
    }

    public static byte startProgram(String fileName) {
        try {
            return nxtCommand.startProgram(fileName);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
    }

    public static byte stopProgram() {
        try {
            return nxtCommand.stopProgram();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return -1;
        }
    }
}

