/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Timer;
import lejos.nxt.remote.InputValues;
import lejos.nxt.remote.NXTCommRequest;
import lejos.nxt.remote.NXTCommand;
import lejos.nxt.remote.OutputState;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommFactory;
import lejos.pc.comm.NXTCommLogListener;
import lejos.pc.comm.NXTConnector;
import lejos.pc.comm.NXTInfo;
import lejos.pc.tools.LabeledGauge;
import lejos.pc.tools.NXTConnectionModel;
import lejos.pc.tools.SensorPanel;
import lejos.pc.tools.ToolsLogger;

public class NXJMonitor
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 2107625009450493352L;
    public static final int MODE_RAW = 0;
    public static final int MODE_BOOLEAN = 32;
    public static final int MODE_TRANSITIONCNT = 64;
    public static final int MODE_PERIODCOUNTER = 96;
    public static final int MODE_PCTFULLSCALE = 128;
    public static final int MODE_CELSIUS = 160;
    public static final int MODE_FARENHEIT = 192;
    public static final int MODE_ANGLESTEP = 224;
    public static final int TYPE_NO_SENSOR = 0;
    public static final int TYPE_SWITCH = 1;
    public static final int TYPE_TEMPERATURE = 2;
    public static final int TYPE_REFLECTION = 3;
    public static final int TYPE_ANGLE = 4;
    public static final int TYPE_LIGHT_ACTIVE = 5;
    public static final int TYPE_LIGHT_INACTIVE = 6;
    public static final int TYPE_SOUND_DB = 7;
    public static final int TYPE_SOUND_DBA = 8;
    public static final int TYPE_CUSTOM = 9;
    public static final int TYPE_LOWSPEED = 10;
    public static final int TYPE_LOWSPEED_9V = 11;
    private static String[] sensorTypes = new String[]{"No Sensor", "Touch Sensor", "Remperature", "RCX Light", "RCX Rotation", "Light Active", "Light Inactive", "Sound DB", "Sound DBA", "Custom", "I2C", "I2C 9V"};
    private String title = "NXJ Monitor";
    private NXTCommand nxtCommand = new NXTCommand();
    private Timer timer;
    private SensorPanel[] sensorPanels = new SensorPanel[]{new SensorPanel("Sensor 1"), new SensorPanel("Sensor 2"), new SensorPanel("Sensor 3"), new SensorPanel("Sensor 4")};
    private LabeledGauge[] motorPanels = new LabeledGauge[]{new LabeledGauge("Motor A Tacho", 270), new LabeledGauge("Motor B Tacho", 270), new LabeledGauge("Motor C Tacho", 270)};
    private LabeledGauge batteryGauge = new LabeledGauge("Battery", 10000);
    private InputValues[] sensorValues = new InputValues[4];
    private OutputState[] motorValues = new OutputState[3];
    private int mv;
    private JLabel textLabel = new JLabel("Trace messages");
    private JTextArea text = new JTextArea(10, 60);
    private String[] textStrings = new String[10];
    private int numStrings = 0;

    public NXJMonitor() {
        this.setTitle(this.title);
        WindowAdapter listener = new WindowAdapter(){

            public void windowClosing(WindowEvent w) {
                try {
                    if (NXJMonitor.this.nxtCommand != null) {
                        NXJMonitor.this.nxtCommand.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(0);
            }
        };
        this.addWindowListener(listener);
        this.setSize(500, 300);
    }

    public void run() throws NXTCommException {
        int protocols = 3;
        final NXJMonitor frame = this;
        NXTConnector conn = new NXTConnector();
        conn.addLogListener((NXTCommLogListener)new ToolsLogger());
        final NXTInfo[] nxts = conn.search(null, null, protocols);
        if (nxts.length == 0) {
            System.err.println("No NXT found - is it switched on and plugged in (for USB)?");
            System.exit(1);
        }
        NXTConnectionModel nm = new NXTConnectionModel(nxts, nxts.length);
        final JTable nxtTable = new JTable(nm);
        JScrollPane nxtTablePane = new JScrollPane(nxtTable);
        nxtTable.setRowSelectionInterval(0, 0);
        this.getContentPane().add((Component)nxtTablePane, "Center");
        JButton connectButton = new JButton("Connect");
        connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int row = nxtTable.getSelectedRow();
                if (row >= 0) {
                    boolean open = false;
                    try {
                        NXTComm nxtComm = NXTCommFactory.createNXTComm((int)nxts[row].protocol);
                        open = nxtComm.open(nxts[row], 1);
                        NXJMonitor.this.nxtCommand.setNXTComm((NXTCommRequest)nxtComm);
                    }
                    catch (NXTCommException n) {
                        open = false;
                    }
                    if (!open) {
                        JOptionPane.showMessageDialog(frame, "Failed to connect");
                    } else {
                        NXJMonitor.this.showMonitor(nxts[row].name);
                    }
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(connectButton);
        this.getContentPane().add((Component)new JScrollPane(buttonPanel), "South");
        this.pack();
        this.setVisible(true);
    }

    private void showMonitor(String name) {
        int i;
        Container contentPane = this.getContentPane();
        JPanel contentPanel = new JPanel();
        this.setTitle(this.title + " : " + name);
        contentPane.removeAll();
        contentPane.add(contentPanel);
        JPanel sensorsPanel = new JPanel();
        JPanel motorsPanel = new JPanel();
        JPanel textPanel = new JPanel();
        sensorsPanel.setBorder(BorderFactory.createEtchedBorder(1));
        sensorsPanel.setBackground(Color.DARK_GRAY);
        motorsPanel.setBackground(Color.DARK_GRAY);
        for (i = 0; i < 4; ++i) {
            sensorsPanel.add(this.sensorPanels[i]);
        }
        motorsPanel.add(this.batteryGauge);
        motorsPanel.setBorder(BorderFactory.createEtchedBorder(1));
        for (i = 0; i < 3; ++i) {
            motorsPanel.add(this.motorPanels[i]);
        }
        textPanel.setLayout(new BoxLayout(textPanel, 3));
        textPanel.setBorder(BorderFactory.createEtchedBorder(1));
        textPanel.add(this.textLabel);
        this.textLabel.setAlignmentX(0.5f);
        textPanel.add(this.text);
        contentPanel.setLayout(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)sensorsPanel, "North");
        contentPanel.add((Component)textPanel, "Center");
        contentPanel.add((Component)motorsPanel, "South");
        this.pack();
        this.setVisible(true);
        this.timer = new Timer(1000, this);
        this.timer.setInitialDelay(2000);
        this.timer.start();
    }

    public void showMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        this.getValues();
        for (i = 0; i < 4; ++i) {
            int max = 1024;
            this.sensorPanels[i].setRawVal(this.sensorValues[i].rawADValue);
            if (this.sensorValues[i].sensorMode == -128) {
                max = 100;
            }
            this.sensorPanels[i].setScaledMaxVal(max);
            this.sensorPanels[i].setScaledVal(this.sensorValues[i].scaledValue);
            this.sensorPanels[i].setType(sensorTypes[this.sensorValues[i].sensorType]);
            this.sensorPanels[i].repaint();
        }
        for (i = 0; i < 3; ++i) {
            this.motorPanels[i].setVal(this.motorValues[i].tachoCount);
            this.motorPanels[i].repaint();
        }
        this.batteryGauge.setVal(this.mv);
        this.text.setText("");
        for (i = 0; i < this.numStrings; ++i) {
            this.text.append(this.textStrings[i] + "\n");
        }
        this.text.repaint();
        this.repaint();
    }

    public void getValues() {
        try {
            byte[] msg;
            int i;
            for (i = 0; i < 4; ++i) {
                this.sensorValues[i] = this.nxtCommand.getInputValues(i);
            }
            for (i = 0; i < 3; ++i) {
                this.motorValues[i] = this.nxtCommand.getOutputState(i);
            }
            this.mv = this.nxtCommand.getBatteryLevel();
            while ((msg = this.nxtCommand.messageRead((byte)0, (byte)0, true)).length != 0) {
                String msgString = new String(msg);
                if (this.numStrings == this.textStrings.length) {
                    for (int i2 = 0; i2 < this.textStrings.length - 1; ++i2) {
                        this.textStrings[i2] = this.textStrings[i2 + 1];
                    }
                    this.numStrings = this.textStrings.length - 1;
                }
                this.textStrings[this.numStrings++] = msgString;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    public static void main(String[] args) {
        NXJMonitor frame = new NXJMonitor();
        try {
            frame.run();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

