/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import js.common.CLIToolProgressMonitor;
import js.common.ToolProgressMonitor;
import js.tinyvm.TinyVM;
import js.tinyvm.TinyVMException;
import lejos.pc.comm.NXTCommLoggable;
import lejos.pc.tools.NXJCommandLineParser;
import lejos.pc.tools.NXJUploadException;
import lejos.pc.tools.ToolsLogListener;
import lejos.pc.tools.ToolsLogger;
import lejos.pc.tools.Upload;

public class NXJLinkAndUpload
extends NXTCommLoggable {
    private NXJCommandLineParser fParser = new NXJCommandLineParser();
    private Upload fUpload = new Upload();
    private TinyVM fTinyVM = new TinyVM();

    public NXJLinkAndUpload() {
        this.fTinyVM.addProgressMonitor((ToolProgressMonitor)new CLIToolProgressMonitor());
    }

    public static void main(String[] args) {
        try {
            NXJLinkAndUpload instance = new NXJLinkAndUpload();
            instance.addToolsLogListener(new ToolsLogger());
            instance.run(args);
        }
        catch (Throwable t) {
            System.err.println("an error occurred: " + t.getMessage());
        }
    }

    public void run(String[] args) throws TinyVMException, NXJUploadException {
        if (!this.fParser.parseOrHelp(NXJLinkAndUpload.class, args)) {
            return;
        }
        String binName = this.fParser.getOutput();
        boolean run = this.fParser.isRun();
        boolean blueTooth = this.fParser.isBluetooth();
        boolean usb = this.fParser.isUSB();
        String name = this.fParser.getName();
        String address = this.fParser.getAddress();
        String[] args1 = this.fParser.getRestArgs();
        String firstArg = args1[0];
        if (binName == null) {
            int i = firstArg.lastIndexOf(46) + 1;
            if (i < 0) {
                i = 0;
            }
            binName = firstArg.substring(i) + ".nxj";
        }
        String classpath = TinyVM.joinCP((String)this.fParser.getBP(), (String)this.fParser.getCP());
        this.log("Linking...");
        this.fTinyVM.start(classpath, args1, this.fParser.isAll(), binName, this.fParser.isBigEndian(), this.fParser.isDebug(), this.fParser.getRunTimeOptions(), this.fParser.isVerbose());
        this.log("Uploading...");
        int protocols = 0;
        if (blueTooth) {
            protocols |= 2;
        }
        if (usb) {
            protocols |= 1;
        }
        this.fUpload.upload(name, address, protocols, binName, run);
    }

    public void addToolsLogListener(ToolsLogListener listener) {
        this.fLogListeners.add(listener);
        this.fUpload.addLogListener(listener);
    }

    public void removeToolsLogListener(ToolsLogListener listener) {
        this.fLogListeners.remove(listener);
        this.fUpload.removeLogListener(listener);
    }

    public void addMonitor(ToolProgressMonitor monitor) {
        this.fTinyVM.addProgressMonitor(monitor);
    }

    public void removeMonitor(ToolProgressMonitor monitor) {
        this.fTinyVM.removeProgressMonitor(monitor);
    }
}

