/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import lejos.nxt.remote.NXTCommRequest;
import lejos.nxt.remote.NXTCommand;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommFactory;
import lejos.pc.comm.NXTInfo;
import lejos.pc.comm.NXTSamba;
import lejos.pc.tools.NXJFlashUI;

public class NXJFlashUpdate {
    private static final int MAX_FIRMWARE_PAGES = 400;
    private static final int TOTAL_PAGES = 1024;
    private static final int SETTINGS_PAGES = 1;
    private static final int DIRECTORY_PAGES = 2;
    private static final int MENU_ADDRESS_LOC = 64;
    private static final int MENU_LENGTH_LOC = 68;
    private static final int FLASH_START_PAGE_LOC = 72;
    private static final String VM = "lejos_nxt_rom.bin";
    private static final String MENU = "StartUpText.bin";
    private NXJFlashUI ui;

    public NXJFlashUpdate(NXJFlashUI ui) {
        this.ui = ui;
    }

    void storeWord(byte[] mem, int offset, int val) {
        mem[offset++] = (byte)(val & 0xFF);
        mem[offset++] = (byte)(val >> 8 & 0xFF);
        mem[offset++] = (byte)(val >> 16 & 0xFF);
        mem[offset++] = (byte)(val >> 24 & 0xFF);
    }

    public byte[] createFirmwareImage(String vmName, String menuName, String leJOSHomeDir) throws IOException, FileNotFoundException {
        this.ui.message("Building firmware image.");
        byte[] memoryImage = new byte[102400];
        String home = leJOSHomeDir;
        if (home == null) {
            home = "";
        }
        String SEP = System.getProperty("file.separator");
        if (vmName == null) {
            vmName = home + SEP + "bin" + SEP + VM;
        }
        if (menuName == null) {
            menuName = home + SEP + "bin" + SEP + MENU;
        }
        this.ui.message("VM file: " + vmName);
        this.ui.message("Menu file: " + menuName);
        FileInputStream vm = new FileInputStream(vmName);
        FileInputStream menu = new FileInputStream(menuName);
        int vmLen = vm.read(memoryImage, 0, memoryImage.length);
        int menuStart = (vmLen + 256 - 1) / 256 * 256;
        int menuLen = menu.read(memoryImage, menuStart, memoryImage.length - menuStart);
        this.storeWord(memoryImage, 68, menuLen);
        this.storeWord(memoryImage, 64, menuStart + 0x100000);
        this.storeWord(memoryImage, 72, 400);
        if (menuStart + menuLen >= memoryImage.length) {
            throw new IOException("Combined size of VM and Menu > " + memoryImage.length);
        }
        this.ui.message("VM size: " + vmLen + " bytes.");
        this.ui.message("Menu size: " + menuLen + " bytes.");
        this.ui.message("Total image size " + (menuStart + menuLen) + "/" + memoryImage.length + " bytes.");
        return memoryImage;
    }

    public byte[] createFilesystemImage() {
        this.ui.message("Building filesystem image.");
        byte[] fs = new byte[159744];
        for (int addr = 768; addr <= fs.length - 32; addr += 4) {
            this.storeWord(fs, addr, addr);
            this.storeWord(fs, addr += 4, ~addr);
            this.storeWord(fs, addr += 4, -252645136);
            this.storeWord(fs, addr += 4, 0xF0F0F0F);
            this.storeWord(fs, addr += 4, -1431655766);
            this.storeWord(fs, addr += 4, 0x55555555);
            this.storeWord(fs, addr += 4, 0);
            this.storeWord(fs, addr += 4, -1);
        }
        return fs;
    }

    public NXTSamba openSambaDevice(int timeout) throws NXTCommException, IOException {
        NXTSamba samba = new NXTSamba();
        this.ui.message("Locating device in firmware update mode.");
        NXTInfo[] nxts = samba.search();
        if (nxts.length == 0) {
            for (int i = 0; i < timeout / 1000 && (nxts = samba.search()).length <= 0; ++i) {
                try {
                    this.ui.progress("Searching", i * 100 / (timeout / 1000));
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (nxts.length > 1) {
            throw new NXTCommException("Too many devices in firmware update mode.");
        }
        if (nxts.length == 0) {
            return null;
        }
        if (!samba.open(nxts[0])) {
            throw new NXTCommException("Failed to open device in SAM-BA mode.");
        }
        this.ui.message("Opened device in firmware update mode.");
        return samba;
    }

    public void resetDevice(NXTInfo nxt) throws NXTCommException, IOException {
        this.ui.message("Attempting to reboot the device.");
        NXTComm nxtComm = NXTCommFactory.createNXTComm((int)nxt.protocol);
        NXTCommand cmd = NXTCommand.getSingleton();
        if (!nxtComm.open(nxt, 1)) {
            throw new NXTCommException("Failed to open device in command mode.");
        }
        cmd.setNXTComm((NXTCommRequest)nxtComm);
        cmd.boot();
        cmd.close();
    }

    private static int getPageAddr(int page) {
        return 0x100000 + page * 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int verifyPages(NXTSamba nxt, int first, byte[] memoryImage) throws IOException {
        int failCnt = 0;
        int len = memoryImage.length;
        InputStream is = nxt.createInputStream(NXJFlashUpdate.getPageAddr(first), len);
        try {
            int p = -1;
            for (int i = 0; i < len; ++i) {
                int b;
                int np = i * 100 / len;
                if (np > p) {
                    p = np;
                    this.ui.progress("Verifying", np);
                }
                if ((b = is.read()) < 0) {
                    throw new IOException("EOF came too soon");
                }
                if ((byte)b == memoryImage[i]) continue;
                this.ui.message(String.format("Verify failed at address 0x%08X: expected 0x%02X, found 0x%02X\n", i, memoryImage[i] & 0xFF, b));
                ++failCnt;
            }
        }
        finally {
            is.close();
        }
        this.ui.progress("", 0);
        if (failCnt == 0) {
            this.ui.message("Verified " + memoryImage.length + " bytes ok.");
        } else {
            this.ui.message("Failed to verify " + failCnt + " of " + memoryImage.length + " bytes.");
        }
        return failCnt;
    }

    public void writePages(NXTSamba nxt, int first, byte[] memoryImage) throws IOException {
        int pages = memoryImage.length / 256;
        int p = -1;
        for (int page = 0; page < pages; ++page) {
            int np = page * 100 / pages;
            if (np > p) {
                p = np;
                this.ui.progress("Writing", np);
            }
            nxt.writePage(first + page, memoryImage, page * 256);
        }
        nxt.readWord(NXJFlashUpdate.getPageAddr(first));
        this.ui.progress("", 0);
    }

    public void writeFirmware(NXTSamba nxt, byte[] memoryImage) throws IOException {
        this.ui.message("Unlocking pages.");
        nxt.unlockAllPages();
        this.ui.message("Writing firmware image.");
        this.writePages(nxt, 0, memoryImage);
    }

    public void writeFilesystem(NXTSamba nxt, byte[] fs) throws IOException {
        this.ui.message("Unlocking pages.");
        nxt.unlockAllPages();
        this.ui.message("Writing filesystem image.");
        this.writePages(nxt, 400, fs);
    }

    public int verifyFirmware(NXTSamba nxt, byte[] image) throws IOException {
        this.ui.message("Verifying firmware.");
        return this.verifyPages(nxt, 0, image);
    }

    public int verifyFilesystem(NXTSamba nxt, byte[] fs) throws IOException {
        this.ui.message("Verifying filesystem.");
        return this.verifyPages(nxt, 400, fs);
    }

    public void rebootDevice(NXTSamba nxt) throws IOException {
        this.ui.message("Restarting the device.");
        nxt.reboot();
        nxt.close();
    }

    public void updateDevice(NXTSamba nxt, byte[] memoryImage, byte[] fs, boolean verify) throws IOException {
        this.updateDevice(nxt, memoryImage, fs, verify, verify, true);
    }

    public void updateDevice(NXTSamba nxt, byte[] memoryImage, byte[] fs, boolean verifyFirm, boolean verifyFS, boolean reboot) throws IOException {
        if (memoryImage != null) {
            this.writeFirmware(nxt, memoryImage);
            if (verifyFirm) {
                this.verifyFirmware(nxt, memoryImage);
            }
        }
        if (fs != null) {
            this.writeFilesystem(nxt, fs);
            if (verifyFS) {
                this.verifyFilesystem(nxt, fs);
            }
        }
        if (reboot) {
            this.rebootDevice(nxt);
        }
    }
}

