/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTConnector;
import lejos.pc.comm.NXTInfo;
import lejos.pc.comm.NXTSamba;
import lejos.pc.tools.NXJFlashUI;
import lejos.pc.tools.NXJFlashUpdate;

public class NXJFlashG
extends JFrame {
    private static final long serialVersionUID = 177459839585979953L;
    private JButton goB;
    private JPanel msgPanel;
    private JLabel progressLabel;
    private JTextArea progressTxt;
    private JLabel progBarLabel;
    private JProgressBar progBar;
    private Flasher flasher;
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 700;

    public NXJFlashG() {
        this.initComponents();
        this.setSize(400, 700);
        this.flasher = new Flasher();
        this.setVisible(true);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Install  NXJ  Firmware in  NXT");
        this.setSize(400, 700);
        JPanel p1 = new JPanel();
        this.goB = new JButton();
        this.goB.setText(" Start Program ");
        p1.add(this.goB);
        this.add((Component)p1, "North");
        this.msgPanel = new JPanel();
        this.msgPanel.setPreferredSize(new Dimension(400, 160));
        this.add((Component)this.msgPanel, "South");
        this.progressTxt = new JTextArea();
        this.progressLabel = new JLabel("Progress Log", 0);
        this.progressTxt.setColumns(30);
        this.progressTxt.setRows(70);
        JPanel progress = new JPanel(new BorderLayout());
        progress.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        progress.setMinimumSize(new Dimension(350, 550));
        progress.add((Component)this.progressLabel, "North");
        progress.add((Component)this.progressTxt, "Center");
        JPanel progBarPanel = new JPanel(new BorderLayout());
        progBarPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        progBarPanel.setMinimumSize(new Dimension(300, 50));
        this.progBarLabel = new JLabel(" ", 0);
        this.progBar = new JProgressBar(0, 100);
        this.progBar.setStringPainted(true);
        progBarPanel.add((Component)this.progBar, "North");
        progBarPanel.add((Component)this.progBarLabel, "South");
        progress.add((Component)progBarPanel, "South");
        this.add((Component)progress, "Center");
        this.goB.setText("Start program");
        this.goB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NXJFlashG.this.goBActionPerformed();
            }
        });
    }

    private void goBActionPerformed() {
        this.flasher.start();
    }

    public static void main(String[] args) {
        new NXJFlashG().setVisible(true);
    }

    private class Flasher
    extends Thread
    implements NXJFlashUI {
        NXJFlashUpdate updater = new NXJFlashUpdate(this);

        private Flasher() {
        }

        public void message(String str) {
            NXJFlashG.this.progressTxt.append(str + "\n");
        }

        public void progress(String str, int percent) {
            if (str.length() <= 0) {
                NXJFlashG.this.progBarLabel.setText(" ");
            } else {
                NXJFlashG.this.progBarLabel.setText(str);
            }
            NXJFlashG.this.progBar.setValue(percent);
        }

        public void run() {
            boolean more = true;
            while (more) {
                JOptionPane.showMessageDialog(NXJFlashG.this.msgPanel, "Click OK when your NXT is turned on and connected ");
                try {
                    NXTSamba nxt;
                    String home = System.getProperty("nxj.home");
                    if (home == null) {
                        home = System.getenv("NXJ_HOME");
                    }
                    byte[] memoryImage = this.updater.createFirmwareImage(null, null, home);
                    boolean format = 0 == JOptionPane.showConfirmDialog(NXJFlashG.this.msgPanel, "Do you want to erase all NXT files now?", "Clear memory first", 0);
                    byte[] fs = null;
                    if (format) {
                        fs = this.updater.createFilesystemImage();
                    }
                    if ((nxt = this.openDevice()) != null) {
                        this.updater.updateDevice(nxt, memoryImage, fs, true, true, true);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(NXJFlashG.this.msgPanel, "Bad news: An error has occurred " + e, "Fatal error ", 0);
                    System.exit(1);
                }
                more = 0 == JOptionPane.showConfirmDialog(NXJFlashG.this.msgPanel, "Do you want to flash firmware again?", "Question", 0);
            }
            System.exit(1);
        }

        NXTSamba openDevice() throws NXTCommException, IOException {
            NXTSamba samba = this.updater.openSambaDevice(0);
            if (samba == null) {
                NXJFlashG.this.progressTxt.append("\nNo devices in firmware update mode were found.\nSearching for other NXT devices.\n");
                NXTConnector conn = new NXTConnector();
                NXTInfo[] nxts = conn.search(null, null, 1);
                if (nxts.length <= 0) {
                    JOptionPane.showMessageDialog(NXJFlashG.this.msgPanel, "No NXT found. \nPlease check that it's turned on and connected.", "Warning", 2);
                    return null;
                }
                NXJFlashG.this.progressTxt.append("Found " + nxts[0].name + " Bluetooth address  " + nxts[0].deviceAddress + "\n\n");
                this.updater.resetDevice(nxts[0]);
                samba = this.updater.openSambaDevice(30000);
            }
            if (samba == null) {
                System.err.println("Unable to locate the device in firmware update mode.\nPlease place the device in reset mode and try again.");
            }
            return samba;
        }
    }
}

