/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.IOException;
import javax.swing.table.AbstractTableModel;
import lejos.nxt.remote.FileInfo;
import lejos.nxt.remote.NXTCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedFileModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6173853132812064498L;
    private static final String[] columnNames = new String[]{"File", "Size", "Start Page", "End Page", "Delete"};
    private static final int NUM_COLUMNS = 5;
    public static final int MAX_FILES = 30;
    private Object[][] fileData;
    private int numFiles;
    private FileInfo[] files = new FileInfo[30];
    private NXTCommand nxtCommand;

    public ExtendedFileModel(NXTCommand nxtCommand) {
        this.nxtCommand = nxtCommand;
        this.fetchFiles();
        this.setData(this.files, this.numFiles);
    }

    private void setData(FileInfo[] files, int numFiles) {
        this.numFiles = numFiles;
        this.fileData = new Object[30][5];
        for (int i = 0; i < numFiles; ++i) {
            this.fileData[i][0] = files[i].fileName;
            this.fileData[i][1] = new Integer(files[i].fileSize);
            this.fileData[i][2] = new Integer(files[i].startPage);
            this.fileData[i][3] = new Integer(files[i].startPage + (files[i].fileSize - 1) / 256);
            this.fileData[i][4] = new Boolean(false);
        }
    }

    public void delete(String fileName, int row) throws IOException {
        this.nxtCommand.delete(fileName);
        for (int i = row; i < this.numFiles - 1; ++i) {
            this.fileData[i] = this.fileData[i + 1];
        }
        --this.numFiles;
    }

    @Override
    public int getRowCount() {
        return this.numFiles;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.fileData[row][column];
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.fileData[row][column] = value;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.fileData[0][column].getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 4;
    }

    public String fetchFiles() {
        this.numFiles = 0;
        try {
            this.files[0] = this.nxtCommand.findFirstNXJ("*.*");
            if (this.files[0] != null) {
                this.numFiles = 1;
                for (int i = 1; i < 30; ++i) {
                    this.files[i] = this.nxtCommand.findNextNXJ(this.files[i - 1].fileHandle);
                    if (this.files[i] == null) break;
                    ++this.numFiles;
                }
            }
            this.setData(this.files, this.numFiles);
            return null;
        }
        catch (IOException ioe) {
            return "IOException fetching files";
        }
    }

    public FileInfo getFile(int i) {
        return this.files[i];
    }

    public int numFiles() {
        return this.numFiles;
    }
}

