/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import js.tinyvm.TinyVMException;
import lejos.pc.tools.ConsoleCommandLineParser;
import lejos.pc.tools.ConsoleViewComms;
import lejos.pc.tools.ConsoleViewerUI;
import org.apache.commons.cli.CommandLine;

public class Console
implements ConsoleViewerUI {
    public static void main(String[] args) {
        try {
            new Console().run(args);
        }
        catch (Throwable t) {
            System.err.println("An error has occurred: " + t.getMessage());
        }
    }

    private void run(String[] args) throws TinyVMException {
        boolean connected;
        int protocols = 0;
        ConsoleCommandLineParser fParser = new ConsoleCommandLineParser();
        CommandLine commandLine = fParser.parse(args);
        boolean blueTooth = commandLine.hasOption("b");
        boolean usb = commandLine.hasOption("u");
        String name = commandLine.getOptionValue("n");
        String address = commandLine.getOptionValue("d");
        ConsoleViewComms comm = new ConsoleViewComms(this, false, false);
        if (blueTooth) {
            protocols |= 2;
        }
        if (usb) {
            protocols |= 1;
        }
        if (protocols == 0) {
            protocols = 3;
        }
        if (!(connected = comm.connectTo(name, address, protocols))) {
            this.logMessage("Failed to connect to NXT");
            System.exit(1);
        }
    }

    public void append(String value) {
        System.out.print(value);
    }

    public void updateLCD(byte[] buffer) {
    }

    public void connectedTo(String name, String address) {
    }

    public void logMessage(String msg) {
        System.out.println(msg);
    }

    public void setStatus(String msg) {
    }
}

