/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.UtilsJavaSE;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.Connection;

public class RemoteDevice {
    private String addressStr;
    private long addressLong;

    protected RemoteDevice(String address) {
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        if (address.length() != 12) {
            throw new IllegalArgumentException("Malformed address: " + address + "; should be 12 characters");
        }
        if (address.startsWith("-")) {
            throw new IllegalArgumentException("Malformed address: " + address + "; can't be negative");
        }
        DebugLog.debug("new RemoteDevice", address);
        this.addressStr = RemoteDeviceHelper.formatBluetoothAddress(address);
        try {
            if (this.addressStr.equals(LocalDevice.getLocalDevice().getBluetoothAddress())) {
                throw new IllegalArgumentException("can't use the LocalDevice address.");
            }
        }
        catch (BluetoothStateException e) {
            throw (RuntimeException)UtilsJavaSE.initCause(new RuntimeException("Can't initialize bluetooth support"), e);
        }
        this.addressLong = RemoteDeviceHelper.getAddress(address);
    }

    public boolean isTrustedDevice() {
        return RemoteDeviceHelper.isTrustedDevice(this);
    }

    public String getFriendlyName(boolean alwaysAsk) throws IOException {
        return RemoteDeviceHelper.getFriendlyName(this, this.addressLong, alwaysAsk);
    }

    public final String getBluetoothAddress() {
        return this.addressStr;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof RemoteDevice && ((RemoteDevice)obj).addressLong == this.addressLong;
    }

    public int hashCode() {
        return new Long(this.addressLong).hashCode();
    }

    public static RemoteDevice getRemoteDevice(Connection conn) throws IOException {
        return RemoteDeviceHelper.getRemoteDevice(conn);
    }

    public boolean authenticate() throws IOException {
        return RemoteDeviceHelper.authenticate(this);
    }

    public boolean authorize(Connection conn) throws IOException {
        return RemoteDeviceHelper.authorize(this, conn);
    }

    public boolean encrypt(Connection conn, boolean on) throws IOException {
        return RemoteDeviceHelper.encrypt(this, conn, on);
    }

    public boolean isAuthenticated() {
        return RemoteDeviceHelper.isAuthenticated(this);
    }

    public boolean isAuthorized(Connection conn) throws IOException {
        return RemoteDeviceHelper.isAuthorized(this, conn);
    }

    public boolean isEncrypted() {
        return RemoteDeviceHelper.isEncrypted(this);
    }
}

