/*
 * Decompiled with CFR 0.152.
 */
package js.tools;

import js.tools.CodePacker;
import js.tools.Size;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Packing
implements Comparable<Packing> {
    Size[] array = new Size[CodePacker.list.size()];
    int thisSize = 0;

    Packing() {
    }

    boolean add(int i) {
        Size size = CodePacker.list.get(i);
        if (size.size + this.thisSize <= CodePacker.maxSize) {
            this.array[i] = size;
            this.thisSize += size.size;
            return true;
        }
        return false;
    }

    void remove(int i) {
        if (this.array[i] != null) {
            this.thisSize -= this.array[i].size;
            this.array[i] = null;
        }
    }

    int getSize() {
        return this.thisSize;
    }

    Packing breed(Packing other) {
        int crossOver = (int)(Math.random() * (double)this.array.length);
        Packing offspring = new Packing();
        for (int i = 0; i < this.array.length / 2; ++i) {
            if (this.array[(i + crossOver) % this.array.length] != null) {
                offspring.add((i + crossOver) % this.array.length);
            }
            if (this.array[(i + this.array.length / 2 + crossOver) % this.array.length] == null) continue;
            offspring.add((i + this.array.length / 2 + crossOver) % this.array.length);
        }
        offspring.mutate();
        return offspring;
    }

    void mutate() {
        for (int i = 0; i < this.array.length; ++i) {
            if (!(Math.random() > 0.5)) continue;
            if (this.array[i] == null) {
                this.add(i);
                continue;
            }
            this.remove(i);
        }
    }

    @Override
    public int compareTo(Packing other) {
        return this.thisSize - other.thisSize;
    }
}

