/*
 * Decompiled with CFR 0.152.
 */
package js.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import js.tools.Packing;
import js.tools.Size;

public class CodePacker {
    static ArrayList<Size> list;
    static int maxSize;

    static void shuffle() {
        for (int i = 0; i < list.size() - 1; ++i) {
            int selIndex = (int)(Math.random() * (double)(list.size() - i) + (double)i);
            Size selected = list.get(selIndex);
            list.set(selIndex, list.get(i));
            list.set(i, selected);
        }
    }

    static Packing select(int[] indices) {
        Packing selection = new Packing();
        for (int i = 0; i < indices.length - 1; ++i) {
            int selIndex = (int)(Math.random() * (double)(indices.length - i) + (double)i);
            int at = indices[selIndex];
            indices[selIndex] = indices[i];
            indices[i] = at;
            selection.add(i);
        }
        return selection;
    }

    static Packing pack() {
        int i;
        int[] indices = new int[list.size()];
        for (int i2 = 0; i2 < indices.length; ++i2) {
            indices[i2] = i2;
        }
        TreeSet<Packing> populations = new TreeSet<Packing>();
        for (i = 0; i < indices.length; ++i) {
            Packing packing = CodePacker.select(indices);
            if (packing.thisSize == maxSize) {
                return packing;
            }
            populations.add(packing);
        }
        for (i = 0; i < indices.length * 2; ++i) {
            Packing[] array = populations.toArray(new Packing[populations.size()]);
            Packing offspring = array[i % array.length].breed(array[(int)(Math.random() * (double)array.length)]);
            if (offspring.thisSize == maxSize) {
                return offspring;
            }
            if (!populations.add(offspring)) continue;
            populations.remove(populations.first());
        }
        return (Packing)populations.last();
    }

    public static void main(String[] args) throws Exception {
        String token;
        StringTokenizer st;
        String s;
        int extraStart = 0;
        String ldsFile = args[0];
        String mapFile = args[1];
        String outputFile = args[2];
        StringBuffer prologue = new StringBuffer();
        StringBuffer epilogue = new StringBuffer();
        StringBuffer current = prologue;
        list = new ArrayList();
        BufferedReader br = new BufferedReader(new FileReader(ldsFile));
        while ((s = br.readLine()) != null) {
            current.append(s);
            current.append("\n");
            st = new StringTokenizer(s);
            if (st.hasMoreTokens() && (token = st.nextToken()).equals("extra1")) {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                token = st.nextToken();
                extraStart = Integer.decode(token);
                st.nextToken();
                st.nextToken();
                st.nextToken();
                token = st.nextToken();
                maxSize = Integer.decode(token);
            }
            if (s.indexOf("__extra_start") == -1) continue;
            current = epilogue;
        }
        br.close();
        br = new BufferedReader(new FileReader(mapFile));
        while ((s = br.readLine()) != null) {
            st = new StringTokenizer(s);
            if (!st.hasMoreTokens() || !(token = st.nextToken()).equals(".text")) continue;
            st.nextToken();
            int size = Integer.decode(st.nextToken());
            String file = st.nextToken();
            if (file.equals("main.o") || file.indexOf("init.o") != -1) continue;
            int lparenI = file.indexOf("(");
            if (lparenI != -1) {
                int rparenI = file.indexOf(")");
                file = "*" + file.substring(lparenI + 1, rparenI);
            }
            list.add(new Size(size, file));
        }
        Packing packing = CodePacker.pack();
        System.out.println("Segment size=" + maxSize + ", packing size=" + packing.thisSize);
        PrintWriter pw = new PrintWriter(new FileWriter(outputFile));
        pw.print(prologue);
        for (int i = 0; i < packing.array.length; ++i) {
            if (packing.array[i] == null) continue;
            pw.println(packing.array[i].file + "(.text)");
        }
        pw.print(epilogue);
        pw.close();
    }
}

