/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Logger;
import js.tinyvm.Binary;
import js.tinyvm.ClassRecord;
import js.tinyvm.CodeSequence;
import js.tinyvm.CodeUtilities;
import js.tinyvm.ExceptionRecord;
import js.tinyvm.RecordTable;
import js.tinyvm.Signature;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import js.tinyvm.util.HashVector;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodRecord
implements WritableData {
    Method iMethod;
    ClassRecord iClassRecord;
    RecordTable<ExceptionRecord> iExceptionTable = null;
    CodeSequence iCodeSequence = null;
    int iSignatureId;
    int iNumLocals;
    int iNumOperands;
    int iNumParameters;
    int iNumExceptionHandlers;
    int iFlags;
    boolean isCalled;
    int iCodeStart;
    HashSet<MethodRecord> iIsHiddenBy = new HashSet();
    int markCount = -1;
    private static final Logger _logger = Logger.getLogger("TinyVM");

    public MethodRecord(Method aEntry, Signature aSignature, ClassRecord aClassRec, Binary aBinary, RecordTable<RecordTable<ExceptionRecord>> aExceptionTables, HashVector<Signature> aSignatures) throws TinyVMException {
        boolean pNoBody;
        this.iClassRecord = aClassRec;
        this.iMethod = aEntry;
        Code pCodeAttrib = this.iMethod.getCode();
        boolean bl = pNoBody = this.iMethod.isAbstract() || this.iMethod.isNative();
        assert (pCodeAttrib != null || pNoBody) : "Check: body is present";
        assert (pCodeAttrib == null || !pNoBody) : "Check: no body is present";
        aSignatures.addElement(aSignature);
        this.iSignatureId = aSignatures.indexOf(aSignature);
        if (this.iSignatureId >= 4096) {
            throw new TinyVMException("The total number of unique signatures exceeds 4096");
        }
        int n = this.iNumLocals = pCodeAttrib == null ? 0 : pCodeAttrib.getMaxLocals();
        if (this.iNumLocals > 255) {
            throw new TinyVMException("Method " + aClassRec.getName() + "." + this.iMethod.getName() + " has " + this.iNumLocals + " local words. Only " + 255 + " are allowed.");
        }
        int n2 = this.iNumOperands = pCodeAttrib == null ? 0 : pCodeAttrib.getMaxStack();
        if (this.iNumOperands > 255) {
            throw new TinyVMException("Method " + aClassRec.getName() + "." + this.iMethod.getName() + " has an operand stack " + " whose potential size is " + this.iNumOperands + ". " + "Only " + 255 + " are allowed.");
        }
        this.iNumParameters = MethodRecord.getNumParamWords(this.iMethod);
        if (this.iNumParameters > 16) {
            throw new TinyVMException("Method " + aClassRec.getName() + "." + this.iMethod.getName() + " has " + this.iNumParameters + " parameter words. Only " + 16 + " are allowed.");
        }
        if (this.iMethod.isNative() && !aBinary.isSpecialSignature(aSignature)) {
            throw new TinyVMException("Method " + aClassRec.getName() + "." + this.iMethod.getName() + " is an unknown native method." + " You are probably using JDK APIs" + " or libraries that cannot be run under leJOS.");
        }
        if (pCodeAttrib != null) {
            this.iExceptionTable = new RecordTable("exceptions", true, false);
            CodeException[] pExcepTable = pCodeAttrib.getExceptionTable();
            this.iNumExceptionHandlers = pExcepTable.length;
            if (this.iNumExceptionHandlers > 255) {
                throw new TinyVMException("Method " + aClassRec.getName() + "." + this.iMethod.getName() + " has " + this.iNumExceptionHandlers + " exception handlers. Only " + 255 + " are allowed.");
            }
            this.storeExceptionTable(pExcepTable, aBinary, aClassRec.iCF);
            aExceptionTables.add(this.iExceptionTable);
        }
        this.initFlags();
    }

    public int getFlags() {
        return this.iFlags;
    }

    public ClassRecord getClassRecord() {
        return this.iClassRecord;
    }

    public void initFlags() {
        this.iFlags = 0;
        if (this.iMethod.isNative()) {
            this.iFlags |= 1;
        }
        if (this.iMethod.isSynchronized()) {
            this.iFlags |= 2;
        }
        if (this.iMethod.isStatic()) {
            this.iFlags |= 4;
        }
    }

    public void copyCode(RecordTable<CodeSequence> aCodeSequences, JavaClass aClassFile, Binary aBinary) {
        Code pCodeAttrib = this.iMethod.getCode();
        if (pCodeAttrib != null) {
            this.iCodeSequence = new CodeSequence();
            this.copyCode(pCodeAttrib.getCode(), aClassFile, aBinary);
            aCodeSequences.add(this.iCodeSequence);
        }
    }

    public void postProcessCode(RecordTable<CodeSequence> aCodeSequences, JavaClass aClassFile, Binary aBinary) throws TinyVMException {
        Code pCodeAttrib = this.iMethod.getCode();
        if (pCodeAttrib != null) {
            this.postProcessCode(pCodeAttrib.getCode(), aClassFile, aBinary);
            this.iCodeStart = this.iCodeSequence == null ? 0 : this.iCodeSequence.getOffset();
        }
    }

    public static int getNumParamWords(Method aMethod) {
        Type[] types = aMethod.getArgumentTypes();
        int pWords = 0;
        block3: for (int i = 0; i < types.length; ++i) {
            assert (types[i].getType() <= 15) : "Check: known type";
            switch (types[i].getType()) {
                case 7: 
                case 11: {
                    pWords += 2;
                    continue block3;
                }
                default: {
                    ++pWords;
                }
            }
        }
        return pWords + (aMethod.isStatic() ? 0 : 1);
    }

    public void storeExceptionTable(CodeException[] aExcepTable, Binary aBinary, JavaClass aCF) {
        for (int i = 0; i < aExcepTable.length; ++i) {
            CodeException pExcep = aExcepTable[i];
            try {
                this.iExceptionTable.add(new ExceptionRecord(pExcep, aBinary, aCF));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void copyCode(byte[] aCode, JavaClass aClassFile, Binary aBinary) {
        if (aCode == null) {
            return;
        }
        this.iCodeSequence.setBytes(aCode);
    }

    public void postProcessCode(byte[] aCode, JavaClass aClassFile, Binary aBinary) throws TinyVMException {
        if (aCode == null) {
            return;
        }
        CodeUtilities pUtils = new CodeUtilities(this.iMethod.getName().toString(), aClassFile, aBinary);
        byte[] pNewCode = pUtils.processCode(aCode);
        this.iCodeSequence.setBytes(pNewCode);
    }

    @Override
    public int getLength() {
        return IOUtilities.adjustedSize(11, 2);
    }

    @Override
    public void dump(IByteWriter aOut) throws TinyVMException {
        try {
            aOut.writeU2(this.iSignatureId);
            aOut.writeU2(this.iExceptionTable == null ? 0 : this.iExceptionTable.getOffset());
            this.iCodeStart = this.iCodeSequence == null ? 0 : this.iCodeSequence.getOffset();
            aOut.writeU2(this.iCodeSequence == null ? 0 : this.iCodeSequence.getOffset());
            aOut.writeU1(this.iNumLocals);
            aOut.writeU1(this.iNumOperands);
            aOut.writeU1(this.iNumParameters);
            aOut.writeU1(this.iNumExceptionHandlers);
            aOut.writeU1(this.iFlags);
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public int getNumParameterWords() {
        return this.iNumParameters;
    }

    public int getSignatureId() {
        return this.iSignatureId;
    }

    public boolean equals(Object aOther) {
        if (!(aOther instanceof MethodRecord)) {
            return false;
        }
        MethodRecord mr = (MethodRecord)aOther;
        return mr.iMethod.equals((Object)this.iMethod) && mr.iClassRecord.equals(this.iClassRecord);
    }

    public int hashCode() {
        return this.iMethod.hashCode() ^ this.iClassRecord.hashCode();
    }

    public void markCalled(JavaClass aClassFile, Binary aBinary) throws TinyVMException {
        if (this.isCalled && this.markCount == aBinary.getGeneration()) {
            return;
        }
        this.isCalled = true;
        this.markCount = aBinary.getGeneration();
        for (MethodRecord pMeth : this.iIsHiddenBy) {
            pMeth.iClassRecord.markMethod(pMeth, false);
        }
        Code pCodeAttrib = this.iMethod.getCode();
        if (pCodeAttrib == null) {
            return;
        }
        byte[] aCode = pCodeAttrib.getCode();
        if (aCode == null) {
            return;
        }
        CodeUtilities pUtils = new CodeUtilities(this.iMethod.getName().toString(), aClassFile, aBinary);
        pUtils.processCalls(aCode, aClassFile, aBinary);
    }

    public boolean isCalled() {
        return this.isCalled;
    }

    public int getCodeStart() {
        return this.iCodeStart;
    }

    public void setHiddenBy(MethodRecord pRec) {
        if (!this.iIsHiddenBy.contains(pRec)) {
            this.iIsHiddenBy.add(pRec);
        }
    }

    public RecordTable<ExceptionRecord> getExceptions() {
        return this.iExceptionTable;
    }
}

