/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import js.tinyvm.Binary;
import js.tinyvm.RunTimeOptions;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;

public class MasterRecord
implements WritableData {
    Binary _binary;
    int runTimeOptions = 0;

    public MasterRecord(Binary binary) {
        assert (binary != null) : "Precondition: binary != null";
        this._binary = binary;
    }

    public void setRunTimeOptions(int opt) {
        this.runTimeOptions = opt;
    }

    public String getRunTimeOptions() {
        String opts = "";
        for (RunTimeOptions opt : RunTimeOptions.values()) {
            if ((opt.getValue() & this.runTimeOptions) == 0) continue;
            opts = opts + (Object)((Object)opt) + " ";
        }
        if (opts.equals("")) {
            opts = "<NONE>";
        }
        return opts;
    }

    public void dump(IByteWriter writer) throws TinyVMException {
        assert (writer != null) : "Precondition: writer != null";
        int pMagicNumber = 51958;
        int pConstantTableOffset = this._binary.iConstantTable.getOffset();
        int pNumConstantRecords = this._binary.iConstantTable.size();
        int pConstantValuesOffset = this._binary.iConstantValues.getOffset();
        int pStaticFieldsOffset = this._binary.iStaticFields.getOffset();
        int pStaticStateLength = this._binary.iStaticState.getLength();
        int pNumStaticFields = this._binary.iStaticFields.size();
        int pEntryClassesOffset = this._binary.iEntryClassIndices.getOffset();
        int pNumEntryClasses = this._binary.iEntryClassIndices.size();
        assert (pNumEntryClasses < 256) : "Check: not too much classes";
        int pLastClass = this._binary.iClassTable.size() - 1;
        assert (pLastClass >= 0 && pLastClass < 256) : "Check: class index in range";
        try {
            writer.writeU2(pMagicNumber);
            writer.writeU2(pConstantTableOffset);
            writer.writeU2(pConstantValuesOffset);
            writer.writeU2(pNumConstantRecords);
            writer.writeU2(pStaticFieldsOffset);
            writer.writeU2(pStaticStateLength);
            writer.writeU2(pNumStaticFields);
            writer.writeU2(pEntryClassesOffset);
            writer.writeU1(pNumEntryClasses);
            writer.writeU1(pLastClass);
            writer.writeU2(this.runTimeOptions);
            IOUtilities.writePadding(writer, 4);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public int getLength() {
        return IOUtilities.adjustedSize(20, 4);
    }
}

