/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import java.util.logging.Logger;
import js.tinyvm.Binary;
import js.tinyvm.ClassRecord;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableDataWithOffset;
import js.tinyvm.io.IByteWriter;

public class InterfaceMap
extends WritableDataWithOffset {
    private ClassRecord interfaceRecord;
    private Binary iBinary;
    private int firstClass;
    private int lastClass;
    private int size;
    private static final Logger _logger = Logger.getLogger("TinyVM");

    public InterfaceMap(Binary iBinary, ClassRecord crec) throws TinyVMException {
        if (!crec.isInterface()) {
            throw new TinyVMException("Attempt to create an interface map for a non interface class " + crec.iName);
        }
        this.iBinary = iBinary;
        this.interfaceRecord = crec;
        this.findBounds();
    }

    private void findBounds() {
        this.lastClass = -1;
        this.firstClass = 257;
        for (ClassRecord cr : this.interfaceRecord.iImplementedBy) {
            int index = this.iBinary.getClassIndex(cr);
            if (index > this.lastClass) {
                this.lastClass = index;
            }
            if (index >= this.firstClass) continue;
            this.firstClass = index;
        }
        this.size = this.lastClass < 0 ? 0 : this.lastClass - this.firstClass + 1;
    }

    public int getFirst() {
        return this.firstClass;
    }

    public int getSize() {
        return this.size;
    }

    public int getLength() {
        return (this.size + 7) / 8;
    }

    private byte[] createMap() throws TinyVMException {
        byte[] map = new byte[this.getLength()];
        for (ClassRecord cr : this.interfaceRecord.iImplementedBy) {
            int index = this.iBinary.getClassIndex(cr) - this.firstClass;
            if (index >= this.size) {
                throw new TinyVMException("Class index for " + cr.iName + " exceeds map size " + this.size + " for interface " + this.interfaceRecord.iName);
            }
            int n = index / 8;
            map[n] = (byte)(map[n] | 1 << index % 8);
        }
        return map;
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        byte[] map = this.createMap();
        try {
            for (byte b : map) {
                aOut.writeU1(b);
            }
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }
}

