/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import java.util.logging.Logger;
import js.tinyvm.Binary;
import js.tinyvm.ClassRecord;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMType;
import js.tinyvm.WritableDataWithOffset;
import js.tinyvm.io.IByteWriter;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;

public class ConstantValue
extends WritableDataWithOffset {
    Binary iBinary;
    Object _value;
    private static final Logger _logger = Logger.getLogger("TinyVM");

    public ConstantValue(ConstantPool pool, Constant constant, Binary aBinary) {
        this.iBinary = aBinary;
        this._value = this.value(pool, constant);
        assert (this._value != null) : "Postconditon: result != null";
    }

    public ConstantValue(ClassRecord crec, Binary aBinary) {
        this.iBinary = aBinary;
        this._value = crec;
    }

    public Object value() {
        assert (this._value != null) : "Postconditon: result != null";
        return this._value;
    }

    public TinyVMType getType() {
        if (this._value instanceof Double) {
            return TinyVMType.T_DOUBLE;
        }
        if (this._value instanceof Float) {
            return TinyVMType.T_FLOAT;
        }
        if (this._value instanceof Integer) {
            return TinyVMType.T_INT;
        }
        if (this._value instanceof Long) {
            return TinyVMType.T_LONG;
        }
        if (this._value instanceof String) {
            return TinyVMType.T_OBJECT;
        }
        if (this._value instanceof ClassRecord) {
            return TinyVMType.T_CLASS;
        }
        assert (false) : "Check: known type";
        return null;
    }

    public int getLength() {
        if (this._value instanceof Double) {
            return 8;
        }
        if (this._value instanceof Float) {
            return 4;
        }
        if (this._value instanceof Integer) {
            return 4;
        }
        if (this._value instanceof Long) {
            return 8;
        }
        if (this._value instanceof String) {
            return ((String)this._value).getBytes().length;
        }
        if (this._value instanceof ClassRecord) {
            return 1;
        }
        assert (false) : "Check: known type";
        return -1;
    }

    public int getAlignment() {
        if (this._value instanceof String) {
            return 1;
        }
        return this.getLength();
    }

    public void dump(IByteWriter writer) throws TinyVMException {
        assert (writer != null) : "Precondition: writer != null";
        try {
            if (this._value instanceof Double) {
                double doubleValue = (Double)this._value;
                long longValue = Double.doubleToLongBits(doubleValue);
                writer.writeU4((int)(longValue >> 32));
                writer.writeU4((int)(longValue & 0xFFFFFFFFFFFFFFFFL));
            } else if (this._value instanceof Float) {
                writer.writeU4(Float.floatToIntBits(((Float)this._value).floatValue()));
            } else if (this._value instanceof Integer) {
                writer.writeU4((Integer)this._value);
            } else if (this._value instanceof Long) {
                long longValue = (Long)this._value;
                writer.writeU4((int)(longValue >> 32));
                writer.writeU4((int)(longValue & 0xFFFFFFFFFFFFFFFFL));
            } else if (this._value instanceof String) {
                byte[] bytes = ((String)this._value).getBytes();
                writer.write(bytes);
            } else if (this._value instanceof ClassRecord) {
                int pIdx = this.iBinary.getClassIndex((ClassRecord)this._value);
                writer.writeU1(pIdx);
            } else assert (false) : "Check: known entry type";
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    private Object value(ConstantPool pool, Constant constant) {
        assert (pool != null) : "Precondition: pool != null";
        assert (constant != null) : "Precondition: constant != null";
        Object result = null;
        if (constant instanceof ConstantDouble) {
            result = new Double(((ConstantDouble)constant).getBytes());
        } else if (constant instanceof ConstantFloat) {
            result = new Float(((ConstantFloat)constant).getBytes());
        } else if (constant instanceof ConstantInteger) {
            result = new Integer(((ConstantInteger)constant).getBytes());
        } else if (constant instanceof ConstantLong) {
            result = new Long(((ConstantLong)constant).getBytes());
        } else if (constant instanceof ConstantString) {
            result = new String(((ConstantString)constant).getBytes(pool));
        } else if (constant instanceof ConstantClass) {
            result = this.iBinary.getClassRecord(((ConstantClass)constant).getBytes(pool));
        } else assert (false) : "Check: known type";
        assert (result != null) : "Postconditon: result != null";
        return result;
    }

    public void markUsed() {
        if (this._value instanceof ClassRecord) {
            ((ClassRecord)this._value).markUsed();
        }
    }
}

