/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.PrintWriter;
import java.io.Writer;
import js.tinyvm.Binary;
import js.tinyvm.ClassRecord;
import js.tinyvm.Signature;
import js.tinyvm.TinyVMException;

public class BinaryReport {
    private Binary _binary;

    public BinaryReport(Binary binary) {
        assert (binary != null) : "Precondition: binary != null";
        this._binary = binary;
    }

    public void report(Writer writer) throws TinyVMException {
        PrintWriter out = new PrintWriter(writer);
        for (int pIndex = 0; pIndex < this._binary.iClassTable.size(); ++pIndex) {
            ClassRecord pRec = this._binary.iClassTable.get(pIndex);
            out.println("Class " + pIndex + ": " + pRec.iName);
        }
        int pSize = this._binary.iSignatures.size();
        for (int i = 0; i < pSize; ++i) {
            Signature pSig = this._binary.iSignatures.elementAt(i);
            out.println("Signature " + i + ": " + pSig.getImage());
        }
        out.println("Master record : " + this._binary.iMasterRecord.getLength() + " bytes.");
        out.println("Class records : " + this._binary.iClassTable.size() + " (" + this._binary.iClassTable.getLength() + " bytes).");
        out.println("Field records : " + this._binary.getTotalNumInstanceFields() + " (" + this._binary.iInstanceFieldTables.getLength() + " bytes).");
        out.println("Method records: " + this._binary.getTotalNumMethods() + " (" + this._binary.iMethodTables.getLength() + " bytes).");
        out.println("Code          : " + this._binary.iCodeSequences.size() + " (" + this._binary.iCodeSequences.getLength() + " bytes).");
        out.println("Class table offset   : " + this._binary.iClassTable.getOffset());
        out.println("Constant table offset: " + this._binary.iConstantTable.getOffset());
        out.println("Method tables offset : " + this._binary.iMethodTables.getOffset());
        out.println("Excep tables offset  : " + this._binary.iExceptionTables.getOffset());
    }
}

